/*
 * @(#)QueueManagerStatus.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.status ;

/**
 * キューマネージャステータス.
 * <BR><BR>
 * キューマネージャのステータスを表します.
 *  
 * @version 2007/01/02
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class QueueManagerStatus {
    
    /**
     * キューマネージャステータス : 正常.
     */
    public static final int STATE_SUCCESS = StatusDefine.STATE_SUCCESS ;
    
    /**
     * キューマネージャステータス : 停止.
     */
    public static final int STATE_DOWN = StatusDefine.STATE_DOWN ;
    
    /**
     * キューマネージャステータス : 起動中.
     */
    public static final int STATE_STARTUP = StatusDefine.STATE_STARTUP ;
    
    /**
     * キューマネージャステータス : 停止中.
     */
    public static final int STATE_SHUTDOWN = StatusDefine.STATE_SHUTDOWN ;
    
    /**
     * キューマネージャステータス : 異常.
     */
    public static final int STATE_ERROR = StatusDefine.STATE_ERROR ;
    
    /**
     * チャネルステータス : 計画停止.
     */
    public static final int STATE_PLANNED_STOP = StatusDefine.STATE_CUSTOM_ERROR + 1 ;
    
    /**
     * コンストラクタ.
     */
    private QueueManagerStatus() { }
    
    /**
     * ステータスを文字列に変換.
     * <BR><BR>
     * ステータスを文字列に変換します.
     * <BR>
     * @param state 対象のステータスを設定します.
     * @return String 文字列が返されます.
     */
    public static final String getStateByString( int state ) {
        String ret = StatusDefine.getStateByString( state ) ;
        if( ret == null ) {
            switch( state ) {
                case STATE_PLANNED_STOP :   ret = "計画停止中" ; break ;
            }
        }
        
        return ret ;
    }
}

