/*
 * @(#)QueueStatus.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.status ;

/**
 * キューステータス.
 * <BR><BR>
 * キューのステータスを表します.
 *  
 * @version 2007/01/03
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class QueueStatus {
    
    /**
     * キューステータス : 正常.
     */
    public static final int STATE_SUCCESS = StatusDefine.STATE_SUCCESS ;
    
    /**
     * キューステータス : 停止.
     */
    public static final int STATE_DOWN = StatusDefine.STATE_DOWN ;
    
    /**
     * キューステータス : 起動中.
     */
    public static final int STATE_STARTUP = StatusDefine.STATE_STARTUP ;
    
    /**
     * キューステータス : 停止中.
     */
    public static final int STATE_SHUTDOWN = StatusDefine.STATE_SHUTDOWN ;
    
    /**
     * キューステータス : 異常.
     */
    public static final int STATE_ERROR = StatusDefine.STATE_ERROR ;
    
    /**
     * キューステータス : キュー格納数指定量による警告.
     */
    public static final int STATE_WARNING = StatusDefine.STATE_CUSTOM_WARNING + 1 ;
    
    /**
     * キューステータス : キュー満杯.
     */
    public static final int STATE_FULL = StatusDefine.STATE_CUSTOM_WARNING + 2 ;
    
    /**
     * コンストラクタ.
     */
    private QueueStatus() { }
    
    /**
     * ステータスを文字列に変換.
     * <BR><BR>
     * ステータスを文字列に変換します.
     * <BR>
     * @param state 対象のステータスを設定します.
     * @return String 文字列が返されます.
     */
    public static final String getStateByString( int state ) {
        String ret = StatusDefine.getStateByString( state ) ;
        if( ret == null ) {
            switch( state ) {
                case STATE_WARNING :    ret = "キュー警告" ; break ;
                case STATE_FULL :       ret = "キュー満杯" ; break ;
            }
        }
        
        return ret ;
    }
}

