/*
 * @(#)StatusDefine.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.queue.access.status ;


/**
 * 基本ステータス定義.
 *  
 * @version 2007/01/03
 * @author  masahito suzuki
 * @since   MaachangQ-Access 1.00
 */
public class StatusDefine {
    
    /**
     * ステータス : 警告MASK値.
     */
    public static final int STATE_MASK_WARNING = 0x10000000 ;
    
    /**
     * ステータス : エラーMASK値.
     */
    public static final int STATE_MASK_ERROR = 0x20000000 ;
    
    /**
     * ステータス : 正常.
     */
    public static final int STATE_SUCCESS = 0x00000000 ;
    
    /**
     * ステータス : 停止.
     */
    public static final int STATE_DOWN = 0x20000001 ;
    
    /**
     * ステータス : 起動中.
     */
    public static final int STATE_STARTUP = 0x20000002 ;
    
    /**
     * ステータス : 停止中.
     */
    public static final int STATE_SHUTDOWN = 0x20000003 ;
    
    /**
     * ステータス : 異常.
     */
    public static final int STATE_ERROR = 0x20000004 ;
    
    /**
     * ステータス : カスタム正常ステータス.
     */
    public static final int STATE_CUSTOM_SUCCESS = 0x00000001 ;
    
    /**
     * ステータス : カスタム警告ステータス.
     */
    public static final int STATE_CUSTOM_WARNING = 0x10000001 ;
    
    /**
     * ステータス : カスタム異常ステータス.
     */
    public static final int STATE_CUSTOM_ERROR = 0x20000005 ;
    
    /**
     * コンストラクタ.
     */
    private StatusDefine() {
        
    }
    
    /**
     * ステータスを文字列に変換.
     * <BR><BR>
     * ステータスを文字列に変換します.
     * <BR>
     * @param state 対象のステータスを設定します.
     * @return String 文字列が返されます.
     */
    protected static final String getStateByString( int state ) {
        switch( state ) {
            case STATE_SUCCESS :    return "正常" ;
            case STATE_DOWN :       return "停止" ;
            case STATE_STARTUP :    return "開始中" ;
            case STATE_SHUTDOWN :   return "シャットダウン中" ;
            case STATE_ERROR :      return "エラー" ;
        }
        
        return null ;
    }
}

