/*
 * @(#)AdminCacheCommand.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.command.admin ;

import org.maachang.command.core.AnalysisCommand;
import org.maachang.queue.access.MaachangQAccessDefine;
import org.maachang.queue.access.MaachangQException;
import org.maachang.queue.access.admin.AdminCache;
import org.maachang.queue.access.admin.MaachangQConnectAdmin;
import org.maachang.queue.access.admin.info.CacheInfo;
import org.maachang.queue.access.admin.info.CreateCacheInfo;

/**
 * 管理者用キャッシュコマンド.
 *  
 * @version 2007/01/25
 * @author  masahito suzuki
 * @since   MaachangQ-Command 1.00
 */
public class AdminCacheCommand {
    
    /**
     * 実行条件.
     */
    private static final String EXEC_HEAD = "x" ;
    
    /**
     * キャッシュ名.
     */
    private static final String CACHE_NAME = "n" ;
    
    /**
     * キャッシュサイズ.
     */
    private static final String CACHE_SIZE = "s" ;
    
    
    
    /**
     * 実行タイプ : リスト表示.
     * list.
     */
    private static final String EXEC_LIST = "l" ;
    
    /**
     * 実行タイプ : キャッシュ生成.
     * create.
     */
    private static final String EXEC_CREATE = "c" ;
    
    /**
     * 実行タイプ : キャッシュ削除.
     * remove.
     */
    private static final String EXEC_DELETE = "r" ;
    
    
    
    /**
     * コンストラクタ.
     */
    private AdminCacheCommand() {
        
    }
    
    /**
     * メイン.
     * <BR><BR>
     * @param args
     * @exception Exception
     */
    public static final void main( String[] args )
        throws Exception {
        try {
            new AdminCacheCommand().execution( args ) ;
        } catch( Exception e ) {
            AnalysisCommand.outputError( e ) ;
        }
    }
    
    /**
     * 実行処理.
     * <BR><BR>
     * @param args
     * @exception Exception
     */
    private final void execution( String[] args )
        throws Exception {
        
        String exec = this.execType( args ) ;
        String cacheName = this.getCacheName( args ) ;
        int cacheSize = this.getCacheSize( args ) ;
        
        MaachangQConnectAdmin admin = AnalysisCommand.loginToConnect( args ) ;
        
        AdminCache cache = admin.getAdminCache() ;
        
        // リスト表示.
        if( EXEC_LIST.equals( exec ) ) {
            if( cacheName != null && cacheName.length() > 0 ) {
                this.outputList( true,cache,cacheName ) ;
            }
            else {
                String[] names = cache.getNames() ;
                this.outputNames( true,names ) ;
            }
        }
        // 生成.
        else if( EXEC_CREATE.equals( exec ) ) {
            
            if( cacheName == null || cacheName.length() <= 0 ) {
                throw new MaachangQException(
                    "対象キャッシュ名は存在しません" ) ;
            }
            
            CreateCacheInfo info = new CreateCacheInfo() ;
            info.setName( cacheName ) ;
            info.setSize( cacheSize ) ;
            cache.addCache( info ) ;
            
            System.out.println( cacheName +
                " キャッシュ生成に成功しました" ) ;
            
        }
        // 削除.
        else if( EXEC_DELETE.equals( exec ) ) {
            
            if( cacheName == null || cacheName.length() <= 0 ) {
                throw new MaachangQException(
                    "対象キャッシュ名は存在しません" ) ;
            }
            
            cache.removeCache( cacheName ) ;
            
            System.out.println( cacheName +
                " キャッシュ削除に成功しました" ) ;
        }
        
    }
    
    /**
     * 実行条件を解析.
     */
    private final String execType( String[] args ) {
        String execType = AnalysisCommand.getHeader( args,EXEC_HEAD ) ;
        if( execType == null || ( execType = execType.trim().toLowerCase() ).length() <= 0 ) {
            return EXEC_LIST ;
        }
        else if( execType.startsWith( EXEC_LIST ) == true ) {
            return EXEC_LIST ;
        }
        else if( execType.startsWith( EXEC_CREATE ) == true ) {
            return EXEC_CREATE ;
        }
        else if( execType.startsWith( EXEC_DELETE ) == true ) {
            return EXEC_DELETE ;
        }
        else {
            return EXEC_LIST ;
        }
        
    }
    
    /**
     * キャッシュ名を取得.
     */
    private final String getCacheName( String[] args ) {
        return AnalysisCommand.getParamStringLowerCase( args,CACHE_NAME ) ;
    }
    
    /**
     * キャッシュサイズを取得.
     */
    private final int getCacheSize( String[] args ) {
        int ret = AnalysisCommand.getParamInt( args,CACHE_SIZE ) ;
        if( ret <= 0 ) {
            return MaachangQAccessDefine.DEFAULT_CACHE_SECTOR ;
        }
        else {
            return ret ;
        }
    }
    
    /**
     * リスト表示.
     */
    private final void outputList( boolean mode,AdminCache cache,String name )
        throws Exception {
        
        CacheInfo info = cache.getCache( name ) ;
        if( info != null ) {
            System.out.println( AnalysisCommand.CUT_CODE ) ;
            System.out.println( "name    :" + info.getName() ) ;
            System.out.println( "max     :" + info.getSize() ) ;
            System.out.println( "persent :" + info.getUsePersent() ) ;
        }
        else if( mode == true ) {
            System.out.println( "not cache." ) ;
        }
    }
    
    /**
     * 一覧名表示.
     */
    private final void outputNames( boolean mode,String[] names ) {
        if( names != null && names.length > 0 ) {
            System.out.println( AnalysisCommand.CUT_CODE ) ;
            int len = names.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                System.out.println( "name    :" + names[ i ] ) ;
            }
        }
        else if( mode == true ) {
            System.out.println( "not cache." ) ;
        }
    }
    
}

