/*
 * @(#)AdminChannelCommand.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.command.admin ;

import java.net.InetAddress;

import org.maachang.command.core.AnalysisCommand;
import org.maachang.command.core.ChannelParam;
import org.maachang.command.core.ConnectParam;
import org.maachang.queue.access.MaachangQAccessDefine;
import org.maachang.queue.access.MaachangQException;
import org.maachang.queue.access.admin.AdminChannel;
import org.maachang.queue.access.admin.MaachangQConnectAdmin;
import org.maachang.queue.access.admin.info.ChannelInfo;
import org.maachang.queue.access.admin.info.ChannelKeyInfo;
import org.maachang.queue.access.admin.info.CreateChannelInfo;
import org.maachang.queue.access.admin.info.CreateSendChannelInfo;
import org.maachang.queue.access.admin.info.SendChannelInfo;
import org.maachang.queue.access.status.ChannelStatus;

/**
 * 管理者用チャネルコマンド.
 *  
 * @version 2007/01/25
 * @author  masahito suzuki
 * @since   MaachangQ-Command 1.00
 */
public class AdminChannelCommand {
    
    /**
     * 実行条件.
     */
    private static final String EXEC_HEAD = "x" ;
    
    /**
     * コネクション名.
     */
    private static final String CONNECT_NAME = "n" ;
    
    /**
     * 暗号ワード.
     */
    private static final String CB32_WORD = "w" ;
    
    
    
    /**
     * 実行タイプ : リスト表示.
     * list.
     */
    private static final String EXEC_LIST = "l" ;
    
    /**
     * 実行タイプ : チャネル生成.
     * create.
     */
    private static final String EXEC_CREATE = "c" ;
    
    /**
     * 実行タイプ : チャネル再設定.
     * set.
     */
    private static final String EXEC_SET = "s" ;
    
    /**
     * 実行タイプ : チャネル削除.
     * remove.
     */
    private static final String EXEC_DELETE = "r" ;
    
    /**
     * 実行タイプ : チャネル停止.
     * off.
     */
    private static final String EXEC_STOP = "of" ;
    
    /**
     * 実行タイプ : チャネル開始.
     * on.
     */
    private static final String EXEC_START = "on" ;
    
    
    
    /**
     * コンストラクタ.
     */
    private AdminChannelCommand() {
        
    }
    
    /**
     * メイン.
     * <BR><BR>
     * @param args
     * @exception Exception
     */
    public static final void main( String[] args )
        throws Exception {
        try {
            new AdminChannelCommand().execution( args ) ;
        } catch( Exception e ) {
            AnalysisCommand.outputError( e ) ;
        }
    }
    
    /**
     * 実行処理.
     * <BR><BR>
     * @param args
     * @exception Exception
     */
    private final void execution( String[] args )
        throws Exception {
        
        String exec = this.execType( args ) ;
        String connectName = this.getConnectName( args ) ;
        String cb32Word = this.getCb32Word( args ) ;
        ConnectParam connParam = AnalysisCommand.analysisConnect( args ) ;
        ChannelParam channelParam = AnalysisCommand.getChannelParam( args ) ;
        
        MaachangQConnectAdmin admin = AnalysisCommand.loginToConnect( args ) ;
        
        AdminChannel channel = admin.getAdminChannel() ;
        
        if( channelParam == null || channelParam.getChannel() == null ) {
            throw new MaachangQException(
                "チャネル条件が設定されていません\n" +
                "      パラメータ[-Hmanager@channel:[send/receive]]で設定してください" ) ;
        }
        
        // コネクション条件が設定されていない場合は、
        // デフォルトポートを設定.
        if( connParam == null ) {
            connParam = new ConnectParam() ;
            connParam.setPort( MaachangQAccessDefine.DEFAULT_CHANNEL_PORT ) ;
            connParam.setAddress( null ) ;
        }
        else if( connParam.getPort() <= -1 ) {
            connParam.setPort( MaachangQAccessDefine.DEFAULT_CHANNEL_PORT ) ;
        }
        
        // リスト表示.
        if( EXEC_LIST.equals( exec ) ) {
            if( channelParam.getChannel() != null &&
                channelParam.getChannel().length() > 0 ) {
                this.outputList( true,channel,
                    channelParam.getChannel(),channelParam.getType() ) ;
            }
            else {
                ChannelKeyInfo[] keys = channel.getKeys() ;
                this.outputNames( true,keys ) ;
            }
        }
        // 生成.
        else if( EXEC_CREATE.equals( exec ) ) {
            
            if( channelParam.getChannel() == null ||
                channelParam.getChannel().length() <= 0 ) {
                throw new MaachangQException(
                    "対象チャネル名は存在しません" ) ;
            }
            
            if( connParam.getPort() < -1 ) {
                throw new MaachangQException(
                    "対象チャネルポートは不正です" ) ;
            }
            
            CreateChannelInfo info = null ;
            if( channelParam.getType() == MaachangQAccessDefine.TYPE_SEND ) {
                
                CreateSendChannelInfo send = new CreateSendChannelInfo() ;
                send.setQueueManager( channelParam.getManager() ) ;
                if( connParam.getAddress() == null ) {
                    send.setAddress( null ) ;
                }
                else {
                    send.setAddress(
                        InetAddress.getByName( connParam.getAddress() ) ) ;
                }
                send.setPort( connParam.getPort() ) ;
                send.setConnectName( connectName ) ;
                send.setUseCb32Word( cb32Word ) ;
                
                info = ( CreateChannelInfo )send ;
            }
            else {
                info = new CreateChannelInfo() ;
            }
            
            info.setChannelName( channelParam.getChannel() ) ;
            
            channel.addChannel( info ) ;
            
            System.out.println( channelParam.getChannel() +
                " チャネル生成に成功しました" ) ;
        }
        // 再設定.
        else if( EXEC_SET.equals( exec ) ) {
            
            if( channelParam.getChannel() == null ||
                channelParam.getChannel().length() <= 0 ) {
                throw new MaachangQException(
                    "対象チャネル名は存在しません" ) ;
            }
            
            
            if( connParam.getPort() < -1 ) {
                throw new MaachangQException(
                    "対象チャネルポートは不正です" ) ;
            }
            
            if( channelParam.getType() == MaachangQAccessDefine.TYPE_SEND ) {
                
                SendChannelInfo send = new SendChannelInfo() ;
                send.setQueueManager( channelParam.getManager() ) ;
                send.setAddress( InetAddress.getByName( connParam.getAddress() ) ) ;
                send.setPort( connParam.getPort() ) ;
                send.setConnectName( connectName ) ;
                send.setUseCb32Word( cb32Word ) ;
                send.setChannelName( channelParam.getChannel() ) ;
                
                channel.setSendChannel( send ) ;
                
                System.out.println( channelParam.getChannel() +
                    " チャネル設定に成功しました" ) ;
            }
            else {
                System.out.println( "送信チャネルチャネル以外は処理できません" ) ;
                return ;
            }
            
        }
        // 削除.
        else if( EXEC_DELETE.equals( exec ) ) {
            
            if( channelParam.getChannel() == null ||
                channelParam.getChannel().length() <= 0 ) {
                throw new MaachangQException(
                    "対象チャネル名は存在しません" ) ;
            }
            
            channel.removeChannel( channelParam.getType(),
                channelParam.getChannel() ) ;
            
            System.out.println( channelParam.getChannel() +
                " チャネル削除に成功しました" ) ;
        }
        // 計画停止.
        else if( EXEC_STOP.equals( exec ) ) {
            
            if( channelParam.getChannel() == null ||
                channelParam.getChannel().length() <= 0 ) {
                throw new MaachangQException(
                    "対象チャネル名は存在しません" ) ;
            }
            
            channel.stopChannel( channelParam.getType(),
                channelParam.getChannel() ) ;
            
            System.out.println( channelParam.getChannel() +
                " チャネル停止に成功しました" ) ;
        }
        // 計画停止から復帰.
        else if( EXEC_START.equals( exec ) ) {
            
            if( channelParam.getChannel() == null ||
                channelParam.getChannel().length() <= 0 ) {
                throw new MaachangQException(
                    "対象チャネル名は存在しません" ) ;
            }
            
            channel.startChannel( channelParam.getType(),
                channelParam.getChannel() ) ;
            
            System.out.println( channelParam.getChannel() +
                " チャネル開始に成功しました" ) ;
        }
        
    }
    
    /**
     * 実行条件を解析.
     */
    private final String execType( String[] args ) {
        String execType = AnalysisCommand.getHeader( args,EXEC_HEAD ) ;
        if( execType == null || ( execType = execType.trim().toLowerCase() ).length() <= 0 ) {
            return EXEC_LIST ;
        }
        else if( execType.startsWith( EXEC_LIST ) == true ) {
            return EXEC_LIST ;
        }
        else if( execType.startsWith( EXEC_CREATE ) == true ) {
            return EXEC_CREATE ;
        }
        else if( execType.startsWith( EXEC_SET ) == true ) {
            return EXEC_SET ;
        }
        else if( execType.startsWith( EXEC_DELETE ) == true ) {
            return EXEC_DELETE ;
        }
        else if( execType.startsWith( EXEC_STOP ) == true ) {
            return EXEC_STOP ;
        }
        else if( execType.startsWith( EXEC_START ) == true ) {
            return EXEC_START ;
        }
        else {
            return EXEC_LIST ;
        }
        
    }
    
    /**
     * コネクション名を取得.
     */
    private final String getConnectName( String[] args ) {
        return AnalysisCommand.getParamStringLowerCase( args,CONNECT_NAME ) ;
    }
    
    /**
     * 暗号ワードを取得.
     */
    private final String getCb32Word( String[] args ) {
        return AnalysisCommand.getParamString( args,CB32_WORD ) ;
    }
    
    /**
     * リスト表示.
     */
    private final void outputList( boolean mode,AdminChannel channel,String name,int type )
        throws Exception {
        
        ChannelInfo info = channel.getChannel( type,name ) ;
        if( info != null ) {
            System.out.println( AnalysisCommand.CUT_CODE ) ;
            System.out.println( "name    :" + info.getChannelName() ) ;
            if( type == MaachangQAccessDefine.TYPE_SEND ) {
                SendChannelInfo send = ( SendChannelInfo )info ;
                System.out.println( "type    :SendChannel" ) ;
                System.out.println( "manager :" + send.getQueueManager() ) ;
                if( send.getAddress() != null ) {
                    System.out.println( "addr    :" +
                        send.getAddress().getHostName() ) ;
                }
                System.out.println( "port    :" + send.getPort() ) ;
                System.out.println( "connect :" + send.getConnectName() ) ;
                if( send.getUseCb32Word() != null ) {
                    System.out.println( "cb32Word:" + send.getUseCb32Word() ) ;
                }
            }
            else {
                System.out.println( "type    :ReceiveChannel" ) ;
            }
            
            System.out.println( "state   :" +
                ChannelStatus.getStateByString( info.getState() ) ) ;
            
        }
        else if( mode == true ) {
            System.out.println( "not channel." ) ;
        }
    }
    
    /**
     * 一覧名表示.
     */
    private final void outputNames( boolean mode,ChannelKeyInfo[] names ) {
        if( names != null && names.length > 0 ) {
            System.out.println( AnalysisCommand.CUT_CODE ) ;
            int len = names.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                System.out.println( "name    :" + names[ i ].getChannel() ) ;
                if( names[ i ].getType() == MaachangQAccessDefine.TYPE_SEND ) {
                    System.out.println( "type    :SendChannel" ) ;
                }
                else {
                    System.out.println( "type    :ReceiveChannel" ) ;
                }
            }
        }
        else if( mode == true ) {
            System.out.println( "not cache." ) ;
        }
    }
    
}

