/*
 * @(#)AdminListCommand.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.command.admin ;

import org.maachang.command.core.AnalysisCommand;
import org.maachang.queue.access.MaachangQAccessDefine;
import org.maachang.queue.access.admin.AdminCache;
import org.maachang.queue.access.admin.AdminChannel;
import org.maachang.queue.access.admin.AdminConnect;
import org.maachang.queue.access.admin.AdminQueue;
import org.maachang.queue.access.admin.AdminQueueManager;
import org.maachang.queue.access.admin.MaachangQConnectAdmin;
import org.maachang.queue.access.admin.info.ChannelInfo;
import org.maachang.queue.access.admin.info.ChannelKeyInfo;
import org.maachang.queue.access.admin.info.QueueInfo;
import org.maachang.queue.access.admin.info.QueueKeyInfo;
import org.maachang.queue.access.admin.info.QueueManagerInfo;
import org.maachang.queue.access.admin.info.SendQueueInfo;
import org.maachang.queue.access.status.ChannelStatus;
import org.maachang.queue.access.status.QueueManagerStatus;
import org.maachang.queue.access.status.QueueStatus;

/**
 * 全情報リスト表示コマンド.
 *  
 * @version 2007/01/26
 * @author  masahito suzuki
 * @since   MaachangQ-Command 1.00
 */
public class AdminListCommand {
    
    /**
     * モニター条件.
     */
    private static final String EXEC_MON = "m" ;
    
    /**
     * マネージャ指定.
     */
    private static final String MANAGER = "n" ;
    
    
    /**
     * コンストラクタ.
     */
    private AdminListCommand() {
        
    }
    
    /**
     * メイン.
     * <BR><BR>
     * @param args
     * @exception Exception
     */
    public static final void main( String[] args )
        throws Exception {
        try {
            new AdminListCommand().execution( args ) ;
        } catch( Exception e ) {
            AnalysisCommand.outputError( e ) ;
        }
    }
    
    /**
     * 実行処理.
     * <BR><BR>
     * @param args
     * @exception Exception
     */
    private final void execution( String[] args )
        throws Exception {
        
        int mon = this.getMon( args ) ;
        if( mon > 0 ) {
            if( mon >= 30 ) {
                mon = 30 ;
            }
            else if( mon <= 3 ) {
                mon = 3 ;
            }
            mon *= 1000 ;
        }
        
        MaachangQConnectAdmin admin = AnalysisCommand.loginToConnect( args ) ;
        
        String manager = this.getManager( args ) ;
        if( manager != null &&
            ( manager = manager.trim().toLowerCase() ).length() > 0 ) {
            AdminQueueManager man = admin.getAdminQueueManager() ;
            if( man.isQueueManager( manager ) == false ) {
                manager = null ;
            }
        }
        
        for( ;; ) {
            
            System.out.println(
                "+--------++------------------------------------------------" ) ;
            
            // キューマネージャ表示指定の場合.
            if( manager != null ) {
                this.outputQueueManagerByQueueList( admin,manager ) ;
            }
            // 全体表示指定の場合.
            else {
                // キューマネージャ+キュー名を表示.
                this.outputQueueManagerAndQueue( admin ) ;
                
                System.out.println() ;
                
                // チャネル名を表示.
                this.outputChannel( admin ) ;
                
                // コネクション名を表示.
                this.outputConnect( admin ) ;
                
                // キャッシュ名を表示.
                this.outputCache( admin ) ;
            }
            
            System.out.println(
                "+--------++------------------------------------------------" ) ;
            
            if( mon > 0 ) {
                Thread.sleep( mon ) ;
                System.out.println() ;
            }
            else {
                break ;
            }
        }
    }
    
    /**
     * チャネル一覧表示.
     */
    private final void outputChannel( MaachangQConnectAdmin admin )
        throws Exception {
        
        AdminChannel channel = admin.getAdminChannel() ;
        ChannelKeyInfo[] names = channel.getKeys() ;
        
        if( names != null && names.length > 0 ) {
            int len = names.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                if( names[ i ].getType() == MaachangQAccessDefine.TYPE_SEND ) {
                    System.out.print( "[channel] " +
                        names[ i ].getChannel() + " (s)" ) ;
                    ChannelInfo info = channel.getChannel(
                        MaachangQAccessDefine.TYPE_SEND,names[ i ].getChannel() ) ;
                    System.out.println( " " +
                        ChannelStatus.getStateByString( info.getState() ) ) ;
                }
                else {
                    System.out.println( "[channel] " +
                        names[ i ].getChannel() + " (r)" ) ;
                }
            }
        }
    }
    
    /**
     * コネクション一覧表示.
     */
    private final void outputConnect( MaachangQConnectAdmin admin )
        throws Exception {
        
        AdminConnect connect = admin.getAdminConnect() ;
        String[] names = connect.getNames() ;
        
        if( names != null && names.length > 0 ) {
            int len = names.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                System.out.println( "[connect] " + names[ i ] ) ;
            }
        }
    }
    
    /**
     * キャッシュ一覧表示.
     */
    private final void outputCache( MaachangQConnectAdmin admin )
        throws Exception {
        
        AdminCache cache = admin.getAdminCache() ;
        String[] names = cache.getNames() ;
        
        if( names != null && names.length > 0 ) {
            int len = names.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                System.out.println( "[cache  ] " + names[ i ] ) ;
            }
        }
    }
    
    /**
     * キューマネージャ+キュー一覧を表示.
     */
    private final void outputQueueManagerAndQueue( MaachangQConnectAdmin admin )
        throws Exception {
        
        AdminQueueManager man = admin.getAdminQueueManager() ;
        String[] names = man.getNames() ;
        
        if( names != null && names.length > 0 ) {
            int len = names.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                System.out.print( "[manager] " + names[ i ] ) ;
                QueueManagerInfo info = man.get( names[ i ] ) ;
                System.out.println( " " +
                    QueueManagerStatus.getStateByString( info.getState() ) ) ;
                this.outputQueue( admin,names[ i ] ) ;
            }
            
        }
    }
    
    /**
     * キュー一覧表示.
     */
    private final void outputQueue( MaachangQConnectAdmin admin,String manager )
        throws Exception {
        
        AdminQueue queue = admin.getAdminQueue( manager ) ;
        
        QueueKeyInfo[] names = queue.getKeys() ;
        
        if( names != null && names.length > 0 ) {
            int len = names.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                if( names[ i ].getType() == MaachangQAccessDefine.TYPE_SEND ) {
                    System.out.print( "  @[queue] " +
                        names[ i ].getQueue() + " (s)" ) ;
                    SendQueueInfo send = ( SendQueueInfo )queue.getQueue(
                        names[ i ].getType(),names[ i ].getQueue() ) ;
                    System.out.print( " " +
                        QueueStatus.getStateByString( send.getState() ) ) ;
                    System.out.println( " UZ:" + send.getUseQueueSize() ) ;
                    if( send.getChannelSize() > 0 ) {
                        int lenJ = send.getChannelSize() ;
                        AdminChannel channel = admin.getAdminChannel() ;
                        for( int j = 0 ; j < lenJ ; j ++ ) {
                            String name = send.getChannel( j ) ;
                            System.out.print( "    *[channel] " + name + " (s)" ) ;
                            ChannelInfo info = channel.getChannel(
                                MaachangQAccessDefine.TYPE_SEND,name ) ;
                            System.out.println( " " +
                                ChannelStatus.getStateByString( info.getState() ) ) ;
                        }
                    }
                }
                else {
                    System.out.print( "  @[queue] " +
                        names[ i ].getQueue() + " (r)" ) ;
                    QueueInfo info = queue.getQueue(
                        names[ i ].getType(),names[ i ].getQueue() ) ;
                    System.out.print( " " +
                        QueueStatus.getStateByString( info.getState() ) ) ;
                    System.out.println( " UZ:" + info.getUseQueueSize() ) ;
                }
            }
        }
    }
    
    /**
     * キューマネージャに対するキュー一覧を表示.
     */
    private final void outputQueueManagerByQueueList(
        MaachangQConnectAdmin admin,String manager  )
        throws Exception {
        
        AdminQueueManager man = admin.getAdminQueueManager() ;
        
        System.out.print( "[manager] " + manager ) ;
        QueueManagerInfo info = man.get( manager ) ;
        System.out.println( " " +
            QueueManagerStatus.getStateByString( info.getState() ) ) ;
        this.outputQueue( admin,manager ) ;
    }
    
    /**
     * モニター表示秒.
     */
    private final int getMon( String[] args ) {
        return AnalysisCommand.getParamInt( args,EXEC_MON ) ;
    }
    
    /**
     * マネージャ指定
     */
    private final String getManager( String[] args ) {
        return AnalysisCommand.getParamString( args,MANAGER ) ;
    }
}

