/*
 * @(#)AdminQueueManagerCommand.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.command.admin ;

import org.maachang.command.core.AnalysisCommand;
import org.maachang.queue.access.MaachangQException;
import org.maachang.queue.access.admin.AdminQueueManager;
import org.maachang.queue.access.admin.MaachangQConnectAdmin;
import org.maachang.queue.access.admin.info.CreateQueueManagerInfo;
import org.maachang.queue.access.admin.info.QueueManagerInfo;
import org.maachang.queue.access.status.QueueManagerStatus;

/**
 * 管理者用キューマネージャコマンド.
 *  
 * @version 2007/01/26
 * @author  masahito suzuki
 * @since   MaachangQ-Command 1.00
 */
public class AdminQueueManagerCommand {
    
    /**
     * 実行条件.
     */
    private static final String EXEC_HEAD = "x" ;
    
    /**
     * キューマネージャ名
     */
    private static final String MANAGER_NAME = "n" ;
    
    /**
     * 最大キャッシュサイズ.
     */
    private static final String MAX_CACHE = "m" ;
    
    
    
    /**
     * 実行タイプ : リスト表示.
     * list.
     */
    private static final String EXEC_LIST = "l" ;
    
    /**
     * 実行タイプ : キューマネージャ生成.
     * create.
     */
    private static final String EXEC_CREATE = "c" ;
    
    /**
     * 実行タイプ : キューマネージャ削除.
     * remove.
     */
    private static final String EXEC_DELETE = "r" ;
    
    /**
     * 実行タイプ : キューマネージャ停止.
     * off.
     */
    private static final String EXEC_STOP = "of" ;
    
    /**
     * 実行タイプ : キューマネージャ開始.
     * on.
     */
    private static final String EXEC_START = "on" ;
    
    
    
    /**
     * コンストラクタ.
     */
    private AdminQueueManagerCommand() {
        
    }
    
    /**
     * メイン.
     * <BR><BR>
     * @param args
     * @exception Exception
     */
    public static final void main( String[] args )
        throws Exception {
        try {
            new AdminQueueManagerCommand().execution( args ) ;
        } catch( Exception e ) {
            AnalysisCommand.outputError( e ) ;
        }
    }
    
    /**
     * 実行処理.
     * <BR><BR>
     * @param args
     * @exception Exception
     */
    private final void execution( String[] args )
        throws Exception {
        
        String exec = this.execType( args ) ;
        String managerName = this.getManagerName( args ) ;
        int maxCache = this.getMaxCache( args ) ;
        MaachangQConnectAdmin admin = AnalysisCommand.loginToConnect( args ) ;
        
        AdminQueueManager man = admin.getAdminQueueManager() ;
        
        // リスト表示.
        if( EXEC_LIST.equals( exec ) ) {
            if( managerName != null &&
                managerName.length() > 0 ) {
                this.outputList( true,man,managerName ) ;
            }
            else {
                String[] names = man.getNames() ;
                this.outputNames( true,names ) ;
            }
        }
        // 生成.
        else if( EXEC_CREATE.equals( exec ) ) {
            
            if( managerName == null ||
                managerName.length() <= 0 ) {
                throw new MaachangQException(
                    "対象キューマネージャ名は存在しません" ) ;
            }
            
            CreateQueueManagerInfo info = new CreateQueueManagerInfo() ;
            info.setQueueManager( managerName ) ;
            info.setMaxCacheSize( maxCache ) ;
            
            man.addManager( info ) ;
            
            System.out.println( managerName +
                " キューマネージャ生成に成功しました" ) ;
            
        }
        // 削除.
        else if( EXEC_DELETE.equals( exec ) ) {
            
            if( managerName == null ||
                managerName.length() <= 0 ) {
                throw new MaachangQException(
                    "対象キューマネージャ名は存在しません" ) ;
            }
            
            man.removeManager( managerName ) ;
            
            System.out.println( managerName +
                " キューマネージャ削除に成功しました" ) ;
        }
        // 計画停止.
        else if( EXEC_STOP.equals( exec ) ) {
            
            if( managerName == null ||
                managerName.length() <= 0 ) {
                throw new MaachangQException(
                    "対象キューマネージャ名は存在しません" ) ;
            }
            
            man.stopManager( managerName ) ;
            
            System.out.println( managerName +
                " キューマネージャ停止に成功しました" ) ;
        }
        // 計画停止から復帰.
        else if( EXEC_START.equals( exec ) ) {
            
            if( managerName == null ||
                managerName.length() <= 0 ) {
                throw new MaachangQException(
                    "対象キューマネージャ名は存在しません" ) ;
            }
            
            man.startManager( managerName ) ;
            
            System.out.println( managerName +
                " キューマネージャ開始に成功しました" ) ;
        }
        
    }
    
    /**
     * 実行条件を解析.
     */
    private final String execType( String[] args ) {
        String execType = AnalysisCommand.getHeader( args,EXEC_HEAD ) ;
        if( execType == null || ( execType = execType.trim().toLowerCase() ).length() <= 0 ) {
            return EXEC_LIST ;
        }
        else if( execType.startsWith( EXEC_LIST ) == true ) {
            return EXEC_LIST ;
        }
        else if( execType.startsWith( EXEC_CREATE ) == true ) {
            return EXEC_CREATE ;
        }
        else if( execType.startsWith( EXEC_DELETE ) == true ) {
            return EXEC_DELETE ;
        }
        else if( execType.startsWith( EXEC_STOP ) == true ) {
            return EXEC_STOP ;
        }
        else if( execType.startsWith( EXEC_START ) == true ) {
            return EXEC_START ;
        }
        else {
            return EXEC_LIST ;
        }
        
    }
    
    /**
     * キューマネージャ名を取得.
     */
    private final String getManagerName( String[] args ) {
        return AnalysisCommand.getParamStringLowerCase( args,MANAGER_NAME ) ;
    }
    
    /**
     * 最大キャッシュ数を取得.
     */
    private final int getMaxCache( String[] args ) {
        return AnalysisCommand.getParamInt( args,MAX_CACHE ) ;
    }
    
    /**
     * リスト表示.
     */
    private final void outputList( boolean mode,AdminQueueManager man,String name )
        throws Exception {
        
        QueueManagerInfo info = man.get( name ) ;
        if( info != null ) {
            System.out.println( AnalysisCommand.CUT_CODE ) ;
            System.out.println( "name    :" + info.getQueueManager() ) ;
            System.out.println( "cache   :" + info.isUseCache() ) ;
            if( info.isUseCache() == true ) {
                System.out.println( "maxCache:" + info.getMaxCacheSize() ) ;
                System.out.println( "useCache:" + info.getUseCacheSize() ) ;
            }
            System.out.println( "state   :" +
                QueueManagerStatus.getStateByString( info.getState() ) ) ;
        }
        else if( mode == true ) {
            System.out.println( "not queue manager." ) ;
        }
    }
    
    /**
     * 一覧名表示.
     */
    private final void outputNames( boolean mode,String[] names ) {
        if( names != null && names.length > 0 ) {
            System.out.println( AnalysisCommand.CUT_CODE ) ;
            int len = names.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                System.out.println( "name    :" + names[ i ] ) ;
            }
        }
        else if( mode == true ) {
            System.out.println( "not queue manager." ) ;
        }
    }

}

