/*
 * @(#)ChannelParam.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.command.core ;

import org.maachang.queue.access.MaachangQAccessDefine;

/**
 * チャネルパラメータ.
 *  
 * @version 2007/01/25
 * @author  masahito suzuki
 * @since   MaachangQ-Command 1.00
 */
public class ChannelParam {
    
    private String manager = null ;
    private String channel = null ;
    private int type = MaachangQAccessDefine.TYPE_RECEIVE ;
    /**
     * manager を取得.
     * <BR><BR>
     * @return manager が返されます.
     */
    public String getManager() {
        return manager;
    }
    /**
     * manager を設定.
     * <BR><BR>
     * @param manager manager を設定します.
     */
    public void setManager(String manager) {
        if( manager == null ||
            ( manager = manager.trim().toLowerCase() ).length() <= 0 ) {
            return ;
        }
        this.manager = manager;
    }
    /**
     * channel を取得.
     * <BR><BR>
     * @return channel が返されます.
     */
    public String getChannel() {
        return channel;
    }
    /**
     * channel を設定.
     * <BR><BR>
     * @param channel channel を設定します.
     */
    public void setChannel(String channel) {
        if( channel == null ||
            ( channel = channel.trim().toLowerCase() ).length() <= 0 ) {
            return ;
        }
        this.channel = channel;
    }
    /**
     * type を取得.
     * <BR><BR>
     * @return type が返されます.
     */
    public int getType() {
        return type;
    }
    /**
     * type を設定.
     * <BR><BR>
     * @param type type を設定します.
     */
    public void setType(int type) {
        this.type = type;
    }
    
}

