/*
 * @(#)QueueConnectParam.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.command.core ;

/**
 * コネクション情報.
 *  
 * @version 2007/01/25
 * @author  masahito suzuki
 * @since   MaachangQ-Command 1.00
 */
public class ConnectParam {
    
    private String address = null ;
    private int port = -1 ;
    /**
     * address を取得.
     * <BR><BR>
     * @return address が返されます.
     */
    public String getAddress() {
        return address;
    }
    /**
     * address を設定.
     * <BR><BR>
     * @param address address を設定します.
     */
    public void setAddress(String address) {
        if( address == null ||
            ( address = address.trim() ).length() <= 0 ) {
            this.address = null ;
        }
        else {
            this.address = address;
        }
    }
    /**
     * port を取得.
     * <BR><BR>
     * @return port が返されます.
     */
    public int getPort() {
        return port;
    }
    /**
     * port を設定.
     * <BR><BR>
     * @param port port を設定します.
     */
    public void setPort(int port) {
        this.port = port;
    }
    
}

