/*
 * @(#)LoginParam.java
 *
 * Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved
 */
package org.maachang.command.core ;

import org.maachang.queue.access.MaachangQAccessDefine;

/**
 * ログインパラメータ.
 *  
 * @version 2007/01/25
 * @author  masahito suzuki
 * @since   MaachangQ-Command 1.00
 */
public class LoginParam {
    
    private String user = null ;
    private String passwd = null ;
    private String address = null ;
    private int port = -1 ;
    /**
     * address を取得.
     * <BR><BR>
     * @return address が返されます.
     */
    public String getAddress() {
        if( address == null || address.length() <= 0 ) {
            return AnalysisCommand.LOCAL_HOST ;
        }
        return address;
    }
    /**
     * address を設定.
     * <BR><BR>
     * @param address address を設定します.
     */
    public void setAddress(String address) {
        if( address == null ||
            ( address = address.trim() ).length() <= 0 ) {
            this.address = null ;
        }
        else {
            this.address = address;
        }
    }
    /**
     * passwd を取得.
     * <BR><BR>
     * @return passwd が返されます.
     */
    public String getPasswd() {
        return passwd;
    }
    /**
     * passwd を設定.
     * <BR><BR>
     * @param passwd passwd を設定します.
     */
    public void setPasswd(String passwd) {
        if( passwd == null ||
            ( passwd = passwd.trim() ).length() <= 0 ) {
            this.passwd = null ;
        }
        else {
            this.passwd = passwd;
        }
    }
    /**
     * port を取得.
     * <BR><BR>
     * @return port が返されます.
     */
    public int getPort() {
        if( port <= -1 ) {
            return MaachangQAccessDefine.ADMIN_PORT ;
        }
        return port;
    }
    /**
     * port を設定.
     * <BR><BR>
     * @param port port を設定します.
     */
    public void setPort(int port) {
        this.port = port;
    }
    /**
     * user を取得.
     * <BR><BR>
     * @return user が返されます.
     */
    public String getUser() {
        return user;
    }
    /**
     * user を設定.
     * <BR><BR>
     * @param user user を設定します.
     */
    public void setUser(String user) {
        if( user == null ||
            ( user = user.trim() ).length() <= 0 ) {
            this.user = null ;
        }
        else {
            this.user = user;
        }
    }
    
    
}

