/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import java.io.IOException;
import org.maachang.dbm.engine.FlagMapFile;
import org.maachang.dbm.engine.RandIO;
import org.maachang.dbm.engine.ValueSector;
import org.maachang.util.FileUtil;

public class MSector {
    protected static final int ONE_SECTOR = 8204;
    protected static final int ONE_DATA = 8192;
    protected static final int MAX_SECTOR = 65536;
    private static final int OFFSET = 8204;
    private RandIO fp = null;
    private FlagMapFile space = null;
    private int fileNo = -1;
    private final Object sync = new Object();

    private MSector() {
    }

    public MSector(int fileNo, String filename) throws Exception {
        if (fileNo <= -1 || fileNo >= 128 || filename == null || (filename = filename.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        filename = FileUtil.getFullPath(filename);
        boolean isFile = FileUtil.isFileExists(filename);
        RandIO fp = null;
        fp = !isFile ? new RandIO(8204, 0x200C200CL, filename) : new RandIO(8204, filename);
        this.space = MSector.initSpace(isFile, fp);
        this.fp = fp;
        this.fileNo = fileNo;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.sync;
        synchronized (object) {
            if (this.space != null) {
                this.space.clear();
            }
            if (this.fp != null) {
                this.fp.destroy();
            }
            this.fp = null;
            this.space = null;
            this.fileNo = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws Exception {
        Object object = this.sync;
        synchronized (object) {
            if (!this.check()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            this.space.flush();
        }
    }

    private static final FlagMapFile initSpace(boolean isFile, RandIO fp) throws Exception {
        return new FlagMapFile(!isFile, fp.getRandomAccessFile(), 0, 65536);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(ValueSector sector) throws Exception {
        if (sector == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        Object object = this.sync;
        synchronized (object) {
            int pos;
            block6: {
                if (!this.check()) {
                    throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
                }
                pos = this.space.usePos(0);
                if (pos > -1) break block6;
                return false;
            }
            sector.setPosition(pos);
            sector.setFileNo(this.fileNo);
            this.space.setPos(pos);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(int no, ValueSector sector) throws Exception {
        if (sector == null || sector.getLength() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        Object object = this.sync;
        synchronized (object) {
            if (!this.check()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            if (!this.space.getPos(no)) {
                throw new IOException("\u6307\u5b9a\u30bb\u30af\u30bf\u30fc(" + no + ")\u306f[OFF]\u5229\u7528\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
            }
            this.saveBySector(no, sector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueSector remove(int no) throws Exception {
        ValueSector ret = null;
        Object object = this.sync;
        synchronized (object) {
            if (!this.check()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            if (this.space.getPos(no) && (ret = this.posBySector(no)) != null) {
                this.space.removePos(no);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueSector get(int no) throws Exception {
        ValueSector ret = null;
        Object object = this.sync;
        synchronized (object) {
            if (!this.check()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            if (this.space.getPos(no)) {
                ret = this.posBySector(no);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFileNo() {
        int ret = -1;
        Object object = this.sync;
        synchronized (object) {
            ret = !this.check() ? -1 : this.fileNo;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileName() {
        String ret = null;
        Object object = this.sync;
        synchronized (object) {
            ret = !this.check() ? null : this.fp.getName();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int ret = 0;
        Object object = this.sync;
        synchronized (object) {
            ret = !this.check() ? -1 : this.space.size();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int useSector() {
        int ret = 0;
        Object object = this.sync;
        synchronized (object) {
            ret = !this.check() ? -1 : this.space.maxSize() - this.space.size();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUse() {
        boolean ret = false;
        Object object = this.sync;
        synchronized (object) {
            ret = this.check();
        }
        return ret;
    }

    private boolean check() {
        return this.fp != null && this.space != null;
    }

    private static final int getPosByAddress(int pos) {
        return 8204 + pos * 8204;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueSector posBySector(int pos) throws Exception {
        byte[] b = new byte[8204];
        int addr = MSector.getPosByAddress(pos);
        Object object = this.sync;
        synchronized (object) {
            this.fp.read(b, addr);
        }
        ValueSector ret = ValueSector.load(b);
        ret.setPosition(pos);
        ret.setFileNo(this.fileNo);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveBySector(int pos, ValueSector sector) throws Exception {
        if (sector == null) {
            throw new IOException("\u4e0d\u6b63\u306a\u30bb\u30af\u30bf[" + MSector.getPosByAddress(pos) + "]\u4fdd\u5b58\u3092\u884c\u304a\u3046\u3068\u3057\u307e\u3057\u305f");
        }
        byte[] b = sector.save();
        int addr = MSector.getPosByAddress(pos);
        Object object = this.sync;
        synchronized (object) {
            this.fp.write(b, addr);
        }
        sector.setPosition(pos);
        sector.setFileNo(this.fileNo);
    }
}

