/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import org.maachang.util.StringUtil;

public class NetMask
implements Serializable {
    private static final long serialVersionUID = -7686107137171859532L;
    private int network = 0;
    private int netmask = 0;

    private NetMask() {
    }

    public NetMask(InetAddress addr, String mask) throws Exception {
        if (addr == null || mask == null || mask.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            this.network = NetMask.convertAddrByInt(addr.getHostAddress());
            this.netmask = NetMask.convertAddrByInt(mask);
            if (this.network == 0 || this.netmask == 0) {
                throw new IOException("\u6307\u5b9a\u3057\u305f\u30a2\u30c9\u30ec\u30b9[" + addr + "]\u306f\u4e0d\u6b63\u3067\u3059");
            }
        }
        catch (IOException ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public NetMask(String addr, String mask) throws Exception {
        if (addr == null || addr.length() <= 0 || mask == null || mask.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            this.network = NetMask.convertAddrByInt(addr);
            this.netmask = NetMask.convertAddrByInt(mask);
            if (this.network == 0 || this.netmask == 0) {
                throw new IOException("\u6307\u5b9a\u3057\u305f\u30a2\u30c9\u30ec\u30b9[" + addr + "]\u306f\u4e0d\u6b63\u3067\u3059");
            }
        }
        catch (IOException ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public NetMask(String addr) throws Exception {
        String saddr = null;
        if (addr == null || addr.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            try {
                int msk = NetMask.getAddrToMaskLength(addr);
                saddr = NetMask.getAddr(addr);
                if (msk == 0 || addr == null || addr.length() <= 0) {
                    throw new IOException("\u6307\u5b9a\u3057\u305f\u30a2\u30c9\u30ec\u30b9[" + addr + "]\u306f\u4e0d\u6b63\u3067\u3059");
                }
                this.network = NetMask.convertAddrByInt(saddr);
                this.netmask = NetMask.getSubnet(msk);
                if (this.network == 0 || this.netmask == 0) {
                    throw new IOException("\u6307\u5b9a\u3057\u305f\u30a2\u30c9\u30ec\u30b9[" + addr + "]\u306f\u4e0d\u6b63\u3067\u3059");
                }
            }
            catch (IOException ae) {
                throw ae;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        finally {
            saddr = null;
        }
    }

    public String getNetworkAddress() {
        return NetMask.getIntToAddr(this.network);
    }

    public String getNetMaskNumber() {
        return String.valueOf(this.netmask);
    }

    public String getNetMask() {
        return NetMask.getIntToAddr(this.netmask);
    }

    public String getRangeAddress(int no) {
        int len = ~this.netmask - 1;
        if (no < 0 || no >= len) {
            return null;
        }
        return NetMask.getIntToAddr((this.network & this.netmask) + no + 1);
    }

    public int getRangeSize() {
        return ~this.netmask - 1;
    }

    public String toString() {
        StringBuilder buf = null;
        buf = new StringBuilder();
        buf.append("netaddress:");
        buf.append(NetMask.getIntToAddr(this.network));
        buf.append(" NetMask:");
        buf.append(NetMask.getIntToAddr(this.netmask));
        return buf.toString();
    }

    public boolean isRange(InetAddress addr) {
        if (addr == null) {
            return false;
        }
        return this.isRange(addr.getHostAddress());
    }

    public boolean isRange(String addr) {
        boolean ret = false;
        if (addr == null || addr.length() <= 0) {
            return false;
        }
        try {
            int iaddr = NetMask.convertAddrByInt(addr);
            if ((this.network & this.netmask) == (iaddr & this.netmask) && (this.netmask == -1 || (iaddr &= ~this.netmask) != 0 && iaddr != ~this.netmask)) {
                ret = true;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    private static final String getIntToAddr(int addr) {
        StringBuilder buf = null;
        buf = new StringBuilder();
        buf.append((addr & 0xFF000000) >> 24 & 0xFF);
        buf.append(".");
        buf.append((addr & 0xFF0000) >> 16 & 0xFF);
        buf.append(".");
        buf.append((addr & 0xFF00) >> 8 & 0xFF);
        buf.append(".");
        buf.append(addr & 0xFF);
        return buf.toString();
    }

    private static final String getAddr(String addr) throws Exception {
        String ret = null;
        int pnt = addr.indexOf("/");
        if (pnt == -1) {
            return addr;
        }
        try {
            ret = addr.substring(0, pnt).trim();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return ret;
    }

    private static final int getAddrToMaskLength(String addr) throws Exception {
        int ret;
        int pnt = addr.indexOf("/");
        if (pnt == -1) {
            return 0;
        }
        try {
            ret = Integer.parseInt(addr.substring(pnt + 1).trim());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return ret;
    }

    private static final int convertAddrByInt(String addr) throws Exception {
        int ret;
        ArrayList<String> lst = null;
        try {
            lst = StringUtil.cutString(addr, ".");
            ret = lst != null && lst.size() == 4 ? Integer.parseInt(lst.get(3)) & 0xFF | (Integer.parseInt(lst.get(2)) & 0xFF) << 8 | (Integer.parseInt(lst.get(1)) & 0xFF) << 16 | (Integer.parseInt(lst.get(0)) & 0xFF) << 24 : 0;
        }
        finally {
            if (lst != null) {
                lst.clear();
            }
            lst = null;
        }
        return ret;
    }

    private static final int getSubnet(int length) throws Exception {
        int ret;
        switch (length) {
            case 0: {
                ret = 0;
                break;
            }
            case 1: {
                ret = Integer.MIN_VALUE;
                break;
            }
            case 2: {
                ret = -1073741824;
                break;
            }
            case 3: {
                ret = -536870912;
                break;
            }
            case 4: {
                ret = -268435456;
                break;
            }
            case 5: {
                ret = -134217728;
                break;
            }
            case 6: {
                ret = -67108864;
                break;
            }
            case 7: {
                ret = -33554432;
                break;
            }
            case 8: {
                ret = -16777216;
                break;
            }
            case 9: {
                ret = -8388608;
                break;
            }
            case 10: {
                ret = -4194304;
                break;
            }
            case 11: {
                ret = -2097152;
                break;
            }
            case 12: {
                ret = -1048576;
                break;
            }
            case 13: {
                ret = -524288;
                break;
            }
            case 14: {
                ret = -262144;
                break;
            }
            case 15: {
                ret = -131072;
                break;
            }
            case 16: {
                ret = -65536;
                break;
            }
            case 17: {
                ret = Short.MIN_VALUE;
                break;
            }
            case 18: {
                ret = -16384;
                break;
            }
            case 19: {
                ret = -8192;
                break;
            }
            case 20: {
                ret = -4096;
                break;
            }
            case 21: {
                ret = -2048;
                break;
            }
            case 22: {
                ret = -1024;
                break;
            }
            case 23: {
                ret = -512;
                break;
            }
            case 24: {
                ret = -256;
                break;
            }
            case 25: {
                ret = -128;
                break;
            }
            case 26: {
                ret = -64;
                break;
            }
            case 27: {
                ret = -32;
                break;
            }
            case 28: {
                ret = -16;
                break;
            }
            case 29: {
                ret = -8;
                break;
            }
            case 30: {
                ret = -4;
                break;
            }
            case 31: {
                ret = -2;
                break;
            }
            case 32: {
                ret = -1;
                break;
            }
            default: {
                throw new IOException("\u5bfe\u8c61\u30de\u30b9\u30af\u9577\u304c\u7bc4\u56f2\u5916\u3067\u3059(length:" + length + ")");
            }
        }
        return ret;
    }
}

