/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.conf;

import java.sql.ResultSet;
import java.util.HashMap;
import org.maachang.comet.httpd.engine.auth.HttpdAuthUsers;
import org.maachang.dao.dbms.DbUtil;
import org.maachang.dao.dbms.Record;
import org.maachang.dao.dbms.RecordFactory;

public class AuthUserByDatabase
implements HttpdAuthUsers {
    private static final long MIN_RELOAD_TIME = 15000L;
    private static final long MAX_RELOAD_TIME = 300000L;
    public static final long DEFAULT_RELOAD_TIME = 30000L;
    private String userTable = null;
    private String userColumn = null;
    private String passwdColumn = null;
    private RecordFactory recordFactory = null;
    private long reloadTime = -1L;
    private long beforeAccessTime = -1L;
    private HashMap<String, Object> temporaryUserTable = null;

    private AuthUserByDatabase() {
    }

    public AuthUserByDatabase(RecordFactory recordFactory, String userTable, String user, String passwd) throws Exception {
        this(recordFactory, userTable, user, passwd, 30000L);
    }

    public AuthUserByDatabase(RecordFactory recordFactory, String userTable, String user, String passwd, long reloadTime) throws Exception {
        if (recordFactory == null || userTable == null || (userTable = userTable.trim()).length() <= 0 || user == null || (user = user.trim()).length() <= 0 || passwd == null || (passwd = passwd.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (reloadTime <= 15000L) {
            reloadTime = 15000L;
        } else if (reloadTime >= 300000L) {
            reloadTime = 300000L;
        }
        this.userTable = userTable;
        this.userColumn = user;
        this.passwdColumn = passwd;
        this.recordFactory = recordFactory;
        this.reloadTime = reloadTime;
    }

    public synchronized String[] getPassword(String user) throws Exception {
        if (user == null || (user = user.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u30e6\u30fc\u30b6\u540d\u304c\u4e0d\u6b63\u3067\u3059");
        }
        this.reload();
        Object o = this.temporaryUserTable.get(user);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return new String[]{(String)o};
        }
        return (String[])o;
    }

    public boolean isUser(String user) throws Exception {
        if (user == null || (user = user.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u30e6\u30fc\u30b6\u540d\u304c\u4e0d\u6b63\u3067\u3059");
        }
        this.reload();
        return this.temporaryUserTable.get(user) != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reload() {
        if (this.beforeAccessTime + this.reloadTime > System.currentTimeMillis()) return;
        Record record = null;
        ResultSet result = null;
        try {
            try {
                String sql = "select " + this.userColumn + "," + this.passwdColumn + " from " + DbUtil.convertJavaNameByDBName((String)this.userTable) + " ;";
                record = this.recordFactory.getRecord();
                result = record.executeQuery(sql);
                if (result == null) return;
                if (!result.next()) {
                    return;
                }
                HashMap<String, Object> t = new HashMap<String, Object>();
                do {
                    String[] lst;
                    String user = result.getString(this.userColumn);
                    String passwd = result.getString(this.passwdColumn);
                    if (passwd == null || (passwd = passwd.trim()).length() <= 0) {
                        passwd = "";
                    }
                    Object o = null;
                    Object v = t.get(user);
                    o = v;
                    if (v == null) {
                        t.put(user, passwd);
                        continue;
                    }
                    if (o instanceof String) {
                        lst = new String[]{o, passwd};
                        t.put(user, lst);
                        continue;
                    }
                    lst = o;
                    int len = lst.length;
                    String[] tmp = new String[len + 1];
                    System.arraycopy(lst, 0, tmp, 0, len);
                    tmp[len] = passwd;
                    t.put(user, tmp);
                } while (result.next());
                this.beforeAccessTime = System.currentTimeMillis();
                this.temporaryUserTable = t;
                return;
            }
            finally {
                if (result != null) {
                    try {
                        result.close();
                    }
                    catch (Exception exception) {}
                }
                if (record != null) {
                    record.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

