/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.comet;

import org.maachang.comet.httpd.engine.comet.Comet;
import org.maachang.comet.httpd.engine.comet.ExecutionOnePoolComet;

class ExecutionPoolComet {
    private static final int MAX_POOL = 100;
    private static final int MIN_POOL = 5;
    private static final int DEFAULT_POOL = 10;
    private ExecutionOnePoolComet[] pool = null;
    private int nextNo = -1;
    private final Object sync = new Object();

    public ExecutionPoolComet() {
        this(10);
    }

    public ExecutionPoolComet(int pool) {
        if (pool <= 5) {
            pool = 5;
        } else if (pool >= 100) {
            pool = 100;
        }
        this.pool = new ExecutionOnePoolComet[pool];
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    public synchronized void clear() {
        this.pool = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executionComet(Comet comet, Object args, String groupId) {
        if (this.pool == null) {
            if (comet != null) {
                comet.clear();
            }
            return;
        }
        while (true) {
            Object object = this.sync;
            synchronized (object) {
                ++this.nextNo;
                if (this.pool.length <= this.nextNo) {
                    this.nextNo = 0;
                }
                if (this.pool[this.nextNo] == null) {
                    this.pool[this.nextNo] = new ExecutionOnePoolComet();
                } else if (this.pool[this.nextNo].isStopThread()) {
                    this.pool[this.nextNo] = new ExecutionOnePoolComet();
                }
                if (this.pool[this.nextNo].executionComet(comet, args, groupId)) {
                    break;
                }
                this.waitTime();
            }
        }
    }

    public synchronized boolean isUse() {
        return this.pool == null;
    }

    public synchronized int size() {
        return this.pool == null ? -1 : this.pool.length;
    }

    private void waitTime() {
        try {
            Thread.sleep(30L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

