/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.cache;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.script.SrcScript;
import org.maachang.comet.httpd.engine.script.cache.CacheTable;
import org.maachang.comet.httpd.engine.script.cache.CacheTableWrapper;
import org.maachang.comet.httpd.engine.script.js.JsDef;
import org.maachang.util.Digest;
import org.maachang.util.FileUtil;
import org.maachang.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheScriptByDirectorys {
    private static final Log LOG = LogFactory.getLog(CacheScriptByDirectorys.class);
    protected static final String ENGINE_NAME = "js";
    private static final long CHECK_TIME = 30000L;
    private String name = null;
    private String cacheDir = null;
    protected int packageId = -1;
    private long checkTime = -1L;
    private String check = null;
    private final Object sync = new Object();

    private CacheScriptByDirectorys() {
    }

    public CacheScriptByDirectorys(String name) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (name.indexOf("/") != -1 || name.indexOf("\\") != -1) {
            throw new IllegalArgumentException("\u6307\u5b9a\u6761\u4ef6\u306f\u3001\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u968e\u5c64\u8a2d\u5b9a\u3092\u884c\u3048\u307e\u305b\u3093");
        }
        this.name = name;
        this.cacheDir = FileUtil.getFullPath((String)name);
    }

    protected void finalize() throws Exception {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        Object object = this.sync;
        synchronized (object) {
            this.checkTime = -1L;
            this.check = null;
            this.packageId = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(CacheTableWrapper wrapper) throws Exception {
        if (wrapper == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            Object object = this.sync;
            synchronized (object) {
                this.loadScripts(wrapper);
            }
        }
        catch (Exception e) {
            this.clear();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void script(CacheTableWrapper wrapper) throws Exception {
        if (wrapper == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            Object object = this.sync;
            synchronized (object) {
                if (this.packageId != -1 && this.packageId != JsDef.getDefaultPackageId()) {
                    this.loadScripts(wrapper);
                } else if (this.checkTime + 30000L <= System.currentTimeMillis()) {
                    if (!wrapper.getCacheTable().isParent(this.name)) {
                        this.loadScripts(wrapper);
                    } else {
                        String chk = this.createCheckLib(this.getLibFileNames(this.cacheDir));
                        if (chk == null || !chk.equals(this.check)) {
                            this.loadScripts(wrapper);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.clear();
            throw e;
        }
    }

    public SrcScript getSrcScript(String path) {
        if (!this.isCache(path)) {
            return null;
        }
        try {
            String script = FileUtil.getFileByString((String)path);
            if (script != null) {
                return new SrcScript(script);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCache(String path) {
        return path != null && (path = path.trim()).length() > 0 && path.startsWith(this.name);
    }

    private void loadScripts(CacheTableWrapper wrapper) throws Exception {
        String[] libNames = this.getLibFileNames(this.cacheDir);
        if (libNames != null && libNames.length > 0) {
            int len = libNames.length;
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine engine = manager.getEngineByName(ENGINE_NAME);
            CacheTable cacheTable = wrapper.getCacheTable();
            cacheTable.waitByStartUpdate();
            try {
                wrapper.setCacheAppend(true);
                Bindings bindings = new SimpleBindings(wrapper);
                int i = 0;
                while (i < len) {
                    String script = FileUtil.getFileByString((String)(String.valueOf(this.name) + libNames[i]), (String)"UTF8");
                    if (script != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(">read[" + this.name + "] - " + this.name + libNames[i]));
                        }
                        StringBuilder buf = new StringBuilder();
                        this.packageId = JsDef.pushDefaultPackage(buf);
                        script = buf.append(script).toString();
                        buf = null;
                        engine.put("javax.script.filename", String.valueOf(this.name) + libNames[i]);
                        engine.eval(script, bindings);
                    }
                    ++i;
                }
                bindings = cacheTable.getBindings();
                cacheTable.putParent(this.name, bindings);
            }
            finally {
                wrapper.setCacheAppend(false);
                cacheTable.exitUpdate();
            }
            this.check = this.createCheckLib(libNames);
            this.checkTime = System.currentTimeMillis();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("** " + this.name + "-cache\u3092\u8aad\u307f\u8fbc\u307f"));
            }
        } else {
            this.check = null;
            this.packageId = -1;
            this.checkTime = System.currentTimeMillis();
        }
    }

    private final String createCheckLib(String[] libNames) throws Exception {
        if (libNames == null || libNames.length <= 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        int len = libNames.length;
        buf.append(len);
        int i = 0;
        while (i < len) {
            buf.append("*");
            long time = -1L;
            String fname = String.valueOf(this.cacheDir) + libNames[i];
            fname = StringUtil.changeString((String)fname, (String)"\\", (String)"/");
            if (FileUtil.isFileExists((String)fname)) {
                time = FileUtil.getLastTime((String)fname);
            }
            buf.append(libNames[i]).append("*").append(time);
            ++i;
        }
        byte[] bin = buf.toString().getBytes("UTF8");
        buf = null;
        return Digest.convert((String)"SHA1", (byte[])bin);
    }

    private final String[] getLibFileNames(String dir) throws Exception {
        ArrayList<String> lst = new ArrayList<String>();
        this.list(lst, dir, dir);
        if (lst.size() > 0) {
            int len = lst.size();
            Object[] ret = new String[len];
            int i = 0;
            while (i < len) {
                ret[i] = lst.get(i);
                ++i;
            }
            lst = null;
            Arrays.sort(ret);
            return ret;
        }
        return null;
    }

    private final void list(ArrayList<String> out, String base, String dir) throws Exception {
        File fp = new File(dir);
        String[] names = fp.list();
        fp = null;
        if (names != null && names.length > 0) {
            int len = names.length;
            int i = 0;
            while (i < len) {
                if (names[i] != null && (names[i] = names[i].trim()).length() > 0) {
                    String name = dir + FileUtil.FILE_SPACE + names[i];
                    if (FileUtil.isDirExists((String)name)) {
                        this.list(out, base, name);
                    } else if (name.toLowerCase().endsWith(".ms")) {
                        if ((name = name.substring(base.length(), name.length())).indexOf("\\") != -1) {
                            name = StringUtil.changeString((String)name, (String)"\\", (String)"/");
                        }
                        if (name.startsWith("/")) {
                            name.substring(1, name.length());
                        }
                        out.add(name);
                    }
                }
                ++i;
            }
        }
    }
}

