/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.dao;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.maachang.dao.MaachangDaoException;
import org.maachang.dao.dbms.DbUtil;
import org.maachang.dao.dbms.MetaColumn;
import org.maachang.util.Base64;

public class DaoUtil {
    public static final String convertDateByString(Date date) throws Exception {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy,M,d,H,m,s");
        return fmt.format(date);
    }

    public static final Date convertStringByDate(String string) throws Exception {
        SimpleDateFormat fmt = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss 'GMT'Z' (JST)'", Locale.US);
        return fmt.parse(string);
    }

    public static Object convertByDBObject(MetaColumn meta, String model, String name, Object value) throws MaachangDaoException {
        int type = -1;
        try {
            if (value == null) {
                return null;
            }
            int no = meta.getColumnNameByNumber(DbUtil.convertJavaNameByDBName((String)name));
            if (no == -1) {
                throw new MaachangDaoException("\u6307\u5b9a\u30e2\u30c7\u30eb[" + model + "]\u306b\u3001\u30ab\u30e9\u30e0\u540d[" + name + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            type = meta.getColumnType(no);
            switch (type) {
                case -7: 
                case -6: 
                case 1: 
                case 16: {
                    if (value instanceof String) {
                        value = new Boolean((String)value);
                        break;
                    }
                    if (value instanceof Boolean) break;
                    value = null;
                    break;
                }
                case 4: 
                case 5: {
                    if (value instanceof String) {
                        value = new Integer(DaoUtil.convertFloatByInteger((String)value));
                        break;
                    }
                    value = new Integer(DaoUtil.convertFloatByInteger(String.valueOf(value)));
                    break;
                }
                case -5: {
                    if (value instanceof String) {
                        value = new Long((String)value);
                        break;
                    }
                    value = new Long(DaoUtil.convertFloatByInteger(String.valueOf(value)));
                    break;
                }
                case 8: {
                    if (value instanceof String) {
                        value = new Double((String)value);
                        break;
                    }
                    value = new Double(String.valueOf(value));
                    break;
                }
                case 6: 
                case 7: {
                    if (value instanceof String) {
                        value = new Float((String)value);
                        break;
                    }
                    value = new Float(String.valueOf(value));
                    break;
                }
                case -1: 
                case 12: 
                case 70: {
                    if (value instanceof String) break;
                    value = String.valueOf(value);
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    if (value instanceof Date) {
                        long time = ((Date)value).getTime();
                        if (type == 91) {
                            value = new java.sql.Date(time);
                            break;
                        }
                        if (type == 92) {
                            value = new Time(time);
                            break;
                        }
                        if (type != 93) break;
                        value = new Timestamp(time);
                        break;
                    }
                    if (type == 91 && value instanceof java.sql.Date || type == 92 && value instanceof Time || type == 93 && value instanceof Timestamp) break;
                    value = null;
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    if (value instanceof String) {
                        value = Base64.decode((String)((String)value));
                        break;
                    }
                    if (value instanceof byte[]) break;
                    value = null;
                    break;
                }
                default: {
                    value = null;
                }
            }
            if (value == null) {
                throw new MaachangDaoException("\u30c6\u30fc\u30d6\u30eb[" + model + "]\u306b\u5bfe\u3059\u308b\u30ab\u30e9\u30e0[" + name + "]\u306e\u578b\u306f\u4e0d\u6b63\u3067\u3059");
            }
            return value;
        }
        catch (MaachangDaoException md) {
            throw md;
        }
        catch (Exception e) {
            throw new MaachangDaoException(e);
        }
    }

    public static final Object convertResult(String model, String name, Object data) throws MaachangDaoException {
        if (data == null) {
            return null;
        }
        if (data instanceof java.sql.Date || data instanceof Time || data instanceof Timestamp) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)data);
            if (data instanceof java.sql.Date) {
                StringBuilder buf = new StringBuilder();
                buf.append("new Date:");
                buf.append(cal.get(1));
                buf.append(",");
                buf.append(cal.get(2) + 1);
                buf.append(",");
                buf.append(cal.get(5));
                buf.append(",0,0,0");
                return buf.toString();
            }
            if (data instanceof Time) {
                StringBuilder buf = new StringBuilder();
                buf.append("new Date:0,1,0,");
                buf.append(cal.get(11));
                buf.append(",");
                buf.append(cal.get(12));
                buf.append(",");
                buf.append(cal.get(13));
                return buf.toString();
            }
            if (data instanceof Timestamp) {
                StringBuilder buf = new StringBuilder();
                buf.append("new Date:");
                buf.append(cal.get(1));
                buf.append(",");
                buf.append(cal.get(2) + 1);
                buf.append(",");
                buf.append(cal.get(5));
                buf.append(",");
                buf.append(cal.get(11));
                buf.append(",");
                buf.append(cal.get(12));
                buf.append(",");
                buf.append(cal.get(13));
                return buf.toString();
            }
        } else {
            if (data instanceof byte[]) {
                return data;
            }
            if (data instanceof Boolean || data instanceof Integer || data instanceof Long || data instanceof Float || data instanceof Double || data instanceof String) {
                return data;
            }
        }
        throw new MaachangDaoException("\u6307\u5b9a\u30e2\u30c7\u30eb[" + model + "]\u306e\u30ab\u30e9\u30e0\u540d[" + name + "]\u578b\u306f\u4e0d\u6b63[" + data.getClass().getName() + "]\u3067\u3059.");
    }

    private static final String convertFloatByInteger(String value) {
        int p = value.indexOf(".");
        if (p != -1) {
            return value.substring(0, p);
        }
        return value;
    }
}

