/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.maachang.dbm.engine.MSector;
import org.maachang.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSctArray {
    private static final String SECTOR_PLUS = ".sector";
    private ArrayList<MSector> sectors = null;
    private String directory = null;
    private int useSector = 0;
    private final Object sync = new Object();
    private static final int SECTOR = 8191;
    private static final int MASK = -8192;
    private static final int SHIFT = 13;

    private MSctArray() {
    }

    public MSctArray(String directory) throws Exception {
        if (directory == null || (directory = directory.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if ((directory = FileUtil.getFullPath(directory)).endsWith("\\") || directory.endsWith("/")) {
            directory = directory.substring(0, directory.length() - 1);
        }
        if (!FileUtil.isDirExists(directory)) {
            FileUtil.mkdirs(directory);
        }
        this.sectors = MSctArray.loadSectors(directory);
        this.useSector = this.calcUseSector();
        this.directory = directory;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.sync;
        synchronized (object) {
            if (this.sectors != null) {
                this.destroySectors();
            }
            this.sectors = null;
            this.useSector = 0;
            this.directory = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws Exception {
        Object object = this.sync;
        synchronized (object) {
            if (!this.check()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            this.saveSectors();
        }
    }

    private static final ArrayList<MSector> loadSectors(String directory) throws Exception {
        ArrayList<MSector> ret = new ArrayList<MSector>();
        String[] lst = FileUtil.getFileList(directory);
        if (lst != null) {
            int len = lst.length;
            int cnt = 0;
            int i = 0;
            while (i < len) {
                if (lst[i] != null && (lst[i] = lst[i].trim()).length() > 0 && lst[i].endsWith(SECTOR_PLUS)) {
                    int no;
                    try {
                        no = Integer.parseInt(lst[i].substring(0, lst[i].length() - SECTOR_PLUS.length()));
                    }
                    catch (Exception e) {
                        no = -1;
                    }
                    if (no != -1 && no < 1024) {
                        ++cnt;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < cnt) {
                MSector sector = new MSector(i, directory + FileUtil.FILE_SPACE + String.valueOf(i) + SECTOR_PLUS);
                ret.add(sector);
                ++i;
            }
        }
        return ret;
    }

    private void saveSectors() throws Exception {
        int len = this.sectors.size();
        int i = 0;
        while (i < len) {
            this.sectors.get(i).flush();
            ++i;
        }
    }

    private void destroySectors() {
        int len = this.sectors.size();
        int i = 0;
        while (i < len) {
            this.sectors.get(i).destroy();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add() throws Exception {
        Object object = this.sync;
        synchronized (object) {
            if (!this.check()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            int no = this.sectors.size();
            if (no + 1 >= 1024) {
                throw new IOException("\u30bb\u30af\u30bf\u30fc\u30d5\u30a1\u30a4\u30eb\u306f[1024]\u4ee5\u4e0a\u8ffd\u52a0\u3067\u304d\u307e\u305b\u3093");
            }
            long sz = new File(this.directory).getFreeSpace();
            if (MSector.oneSectorFileSize() >= sz) {
                throw new IOException("\u30d5\u30a1\u30a4\u30eb\u4f5c\u6210\u306b\u5bfe\u3057\u3066\u3001\u5bb9\u91cf[" + sz + "]\u304c\u8db3\u308a\u307e\u305b\u3093");
            }
            MSector sector = new MSector(no, this.directory + FileUtil.FILE_SPACE + String.valueOf(no) + SECTOR_PLUS);
            this.sectors.add(sector);
            this.useSector += 524288;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MSector get(int no) throws Exception {
        MSector ret = null;
        Object object = this.sync;
        synchronized (object) {
            if (!this.check()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            ret = no <= -1 || no >= this.sectors.size() ? null : this.sectors.get(no);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MSector getMaxUseObject(int targetUse) throws Exception {
        if (targetUse <= 0) {
            targetUse = -1;
        }
        MSector ret = null;
        Object object = this.sync;
        synchronized (object) {
            if (!this.check()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            int maxUse = 0;
            int len = this.sectors.size();
            if (len > 1 && this.sectors.get(0).useSector() < this.sectors.get(len - 1).useSector()) {
                int i = len - 1;
                while (i >= 0) {
                    MSector s = this.sectors.get(i);
                    int u = s.useSector();
                    if (targetUse != -1 && targetUse < u) {
                        ret = s;
                        break;
                    }
                    if (maxUse < u) {
                        ret = s;
                        maxUse = u;
                    }
                    --i;
                }
            } else {
                int i = 0;
                while (i < len) {
                    MSector s = this.sectors.get(i);
                    int u = s.useSector();
                    if (targetUse != -1 && targetUse < u) {
                        ret = s;
                        break;
                    }
                    if (maxUse < u) {
                        ret = s;
                        maxUse = u;
                    }
                    ++i;
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeUseSector() {
        Object object = this.sync;
        synchronized (object) {
            if (this.check()) {
                --this.useSector;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addUseSector() {
        Object object = this.sync;
        synchronized (object) {
            if (this.check()) {
                ++this.useSector;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int useSector() {
        int ret = 0;
        Object object = this.sync;
        synchronized (object) {
            ret = !this.check() ? -1 : this.useSector;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int maxSector() {
        int ret = 0;
        Object object = this.sync;
        synchronized (object) {
            ret = !this.check() ? -1 : this.size() * 524288;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int ret = 0;
        Object object = this.sync;
        synchronized (object) {
            ret = !this.check() ? -1 : this.sectors.size();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDirectory() {
        String ret = null;
        Object object = this.sync;
        synchronized (object) {
            ret = !this.check() ? null : this.directory;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUse() {
        boolean ret = false;
        Object object = this.sync;
        synchronized (object) {
            ret = this.check();
        }
        return ret;
    }

    protected static final int sectorLength(int len) {
        return ((len & 0xFFFFE000) >> 13) + ((len & 0x1FFF) != 0 ? 1 : 0);
    }

    private boolean check() {
        return this.sectors != null && this.directory != null;
    }

    private int calcUseSector() {
        int ret = 0;
        int len = this.sectors.size();
        int i = 0;
        while (i < len) {
            int use = this.sectors.get(i).useSector();
            if (use == -1) {
                return -1;
            }
            ret += use;
            ++i;
        }
        return ret;
    }
}

