// 駒を打ったときの処理.
//

if( useString( params['method'] ) == false ||
    useString( params['groupId'] ) == false ||
    startsWith( params['groupId'],"_shogi" ) == false ) {
    exit() ;
}

// 数値文字列表記.
var info_number_by_kanji = ["零","一","ニ","三","四","五","六","七","八","九"] ;

// 駒情報を文字列変換.
var info_koma_by_name = ["歩","成歩","香車","成香","桂馬","成桂","銀","成銀","飛車","竜","角","馬","金","王","玉"] ;

// 保有駒情報を文字列変換.
var info_pos_koma_by_name = ["角","飛車","金","銀","桂馬","香車","歩"] ;

// ユーザを取得.
var userInfo = ShogiUser.first_by_id( params['userId'] ) ;

// メッセージとして保存.
var bean = ShogiChat.bean() ;
var groupId = params['groupId'].substring( "_shogi".length ) ;
bean.fightId = groupId ;
bean.userName = userInfo[0].name ;
bean.message = "" ;

// 勝敗がついた場合.
if( params['srcX'] <= -1 && params['srcY'] == -1 &&
    params['destX'] == -1 && params['destY'] == -1 ) {
    // まだ投了していない場合.
    if( ShogiFight.count_by_id_and_exitFlag( [groupId,true] ) <= 0 ) {
        // 投了で負け.
        if( params['srcX'] == -1 ) {
            bean.message = "投了しました." ;
        }
        // ニ歩で負け.
        else if( params['srcX'] == -2 ) {
            bean.message = "ニ歩をしました." ;
        }
        // 王を取られて負け.
        else if( params['srcX'] == -3 ) {
            bean.message = "王を取りました." ;
        }
        ShogiFight.update( "set $exit_flag=? where $id=?",[true,groupId] ) ;
        // 対戦ユーザの勝敗と得点を付加.
        var game = ShogiFight.first_by_id( groupId )[0] ;
        var userA = userInfo[0] ;
        var userB = null ;
        if( userA.id == game.editUser ) {
            userB = ShogiUser.find_by_id( game.fightUser )[0] ;
        }
        else {
            userB = ShogiUser.find_by_id( game.editUser )[0] ;
        }
        // 投了で負け.
        if( params['srcX'] == -1 ) {
            userA.rate -= 25 ;
            userA.defeat += 1 ;
            userB.rate += 25 ;
            userB.win += 1 ;
        }
        // ニ歩で負け.
        else if( params['srcX'] == -2 ) {
            userA.rate -= 50 ;
            userA.defeat += 1 ;
            userB.rate += 25 ;
            userB.win += 1 ;
        }
        // 王を取られて負け.
        else if( params['srcX'] == -3 ) {
            userA.rate += 25 ;
            userA.win += 1 ;
            userB.rate -= 100 ;
            userB.defeat += 1 ;
        }
        // それぞれを保存.
        ShogiUser.save( userA ) ;
        ShogiUser.save( userB ) ;
    }
}
else {
    if( params['mode'] == true ) {
        bean.message += "▲" ;
    }
    else {
        bean.message += "△" ;
    }
    if( params['srcX'] == -1 && params['srcY'] == -1 ) {
        bean.message+=""+params['destX']+info_number_by_kanji[params['destY']] ;
        bean.message+=""+info_pos_koma_by_name[params['koma']]+"打" ;
    }
    else {
        // 同打ちであるかチェック.
        var notDou = false ;
        var bef = ShogiInfo.first_by_fightId( groupId,"id desc" ) ;
        if( isNull( bef ) == false && bef.length > 0 ) {
            if( "" + bef[0].destX == "" + params['destX'] &&
                "" + bef[0].destY == "" + params['destY'] ) {
                bean.message+="同" ;
                notDou = true ;
            }
        }
        // 同打ちでない場合.
        if( notDou == false ) {
            bean.message+=""+params['destX']+info_number_by_kanji[params['destY']] ;
        }
        bean.message+=""+info_koma_by_name[params['koma']] ;
    }
}

// チャット内容を保存.
ShogiChat.save( bean ) ;
var chatId = bean.id ;

// 打った内容を保存.
var bean = ShogiInfo.bean() ;
bean.fightId = groupId ;
bean.insertUser = params['userId'] ;
bean.koma = params['koma'] ;
bean.srcX = params['srcX'] ;
bean.srcY = params['srcY'] ;
bean.destX = params['destX'] ;
bean.destY = params['destY'] ;

// 駒内容を保存.
ShogiInfo.save( bean ) ;
var komaId = bean.id ;

// コメット実行(駒実行).
executionComet( [{"type":"koma","komaId":""+komaId,"chatId":""+chatId}] ) ;
