package org.maachang.comet.httpd.engine.script;

import java.util.HashMap;

import javax.script.ScriptContext;

/**
 * スクリプト実行処理.
 * 
 * @version 2007/08/24
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
public interface ExecutionScript {
    
    /**
     * スクリプト単体実行.
     * <BR><BR>
     * スクリプトを単体で実行します.<BR>
     * このメソッドは、主に[InnerScript]等、スクリプト内で実行する場合に
     * 呼び出されます.
     * <BR>
     * @param ctx 対象のスクリプトコンテキストを設定します.
     * @exception Exception 例外.
     */
    public Object eval( ScriptContext ctx ) throws Exception ;
    
    /**
     * スクリプト実行.
     * <BR><BR>
     * 対象のスクリプトを実行します.
     * <BR>
     * @param params 対象のパラメータを設定します.
     * @return Object 処理結果が返されます.
     * @exception Exception 例外.
     */
    public Object execution( HashMap<String,Object> params ) throws Exception ;
    
    /**
     * スクリプト実行.
     * <BR><BR>
     * 対象のスクリプトを実行します.
     * <BR>
     * @param ctx 対象のスクリプトコンテキストを設定します.
     * @param params 対象のパラメータを設定します.
     * @return Object 処理結果が返されます.
     * @exception Exception 例外.
     */
    public Object execution( ScriptContext ctx,HashMap<String,Object> params ) throws Exception ;
    
    /**
     * スクリプト識別子を取得.
     * <BR><BR>
     * スクリプト識別子を取得します.
     * <BR>
     * @return String スクリプト識別子が返されます.
     */
    public String getCommand() ;
    
    /**
     * スクリプトデータタイプを取得.
     * <BR><BR>
     * スクリプトデータタイプを取得します.
     * <BR>
     * @return スクリプトデータタイプが返されます.
     */
    public int getScriptDataType() ;
    
    /**
     * スクリプト名を取得.
     * <BR><BR>
     * スクリプト名を取得します.
     * <BR>
     * @return String スクリプト名が返されます.
     */
    public String getScriptName() ;
    
    /**
     * デフォルトパラメータを設定.
     * <BR><BR>
     * デフォルトパラメータを設定します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @param value 対象の要素を設定します.
     */
    public void putDefault( String key,Object value ) ;
    
}
