/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.maachang.util.FileUtil;

class RandIO {
    private static final int DEFAULT_BUFFER = 512;
    private String name = null;
    private RandomAccessFile rfp = null;
    private FileChannel channel = null;
    private ByteBuffer buffer = null;
    private int length = -1;

    private RandIO() {
    }

    public RandIO(int buffer, String name) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!FileUtil.isFileExists((String)name)) {
            throw new IOException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb\u540d[" + name + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (buffer <= 512) {
            buffer = 512;
        }
        this.rfp = new RandomAccessFile(name, "rwd");
        this.channel = this.rfp.getChannel();
        this.name = name;
        this.buffer = ByteBuffer.allocateDirect(buffer);
        this.length = (int)this.rfp.length();
    }

    public RandIO(int buffer, long size, String name) throws Exception {
        if (size <= 0L || name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.rfp = new RandomAccessFile(name, "rwd");
        if (FileUtil.isFileExists((String)name)) {
            this.rfp.setLength(0L);
        }
        if (buffer <= 512) {
            buffer = 512;
        }
        this.rfp.setLength(size);
        this.channel = this.rfp.getChannel();
        this.name = name;
        this.buffer = ByteBuffer.allocateDirect(buffer);
        this.length = (int)this.rfp.length();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.rfp != null) {
            try {
                this.channel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.rfp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.rfp = null;
        this.channel = null;
        this.name = null;
        this.buffer = null;
        this.length = -1;
    }

    public synchronized void expansion(int size) throws Exception {
        if (size <= 0) {
            return;
        }
        int newLen = this.length + size;
        this.rfp.setLength(newLen);
        this.length = newLen;
    }

    public synchronized int read(byte[] out, long seek) throws Exception {
        return this.read(out, seek, 0, out.length);
    }

    public synchronized int read(byte[] out, long seek, int offset, int length) throws Exception {
        this.channel.position(seek);
        int ret = 0;
        while (length > 0) {
            int len;
            this.buffer.clear();
            if (length < this.buffer.capacity()) {
                this.buffer.limit(length);
            }
            if ((len = this.channel.read(this.buffer)) <= 0) break;
            this.buffer.flip();
            this.buffer.get(out, offset, this.buffer.limit());
            offset += len;
            length -= len;
            ret += len;
        }
        return ret;
    }

    public synchronized void write(byte[] in, long seek) throws Exception {
        this.write(in, seek, 0, in.length);
    }

    public synchronized void write(byte[] in, long seek, int offset, int length) throws Exception {
        this.channel.position(seek);
        if ((int)seek + length >= this.length) {
            if ((int)seek >= this.length) {
                return;
            }
            length = this.length - (int)seek;
        }
        while (length > 0) {
            this.buffer.clear();
            int writeLen = this.buffer.capacity();
            if (length < this.buffer.capacity()) {
                writeLen = length;
            }
            this.buffer.put(in, offset, writeLen);
            this.buffer.flip();
            this.channel.write(this.buffer);
            offset += writeLen;
            length -= writeLen;
        }
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized long getLength() {
        return this.length;
    }

    public synchronized RandomAccessFile getRandomAccessFile() {
        return this.rfp;
    }
}

