/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

public class CharsetMask {
    public static final String ISO_8859_1 = "ISO8859_1";
    public static final String UTF8 = "UTF8";
    public static final String UTF16 = "UTF16";
    public static final String UTF32 = "UTF32";
    public static final String ASCII = "ASCII";
    public static final String JIS = "ISO2022JP";
    public static final String EUC = "EUC_JP";
    public static final String SJIS = "Shift_JIS";
    public static final String MS932 = "MS932";
    public static final String WIN31J = "Windows-31J";
    private static final String[] CONVERT_CODE = new String[]{"ISO8859_1", "ISO8859_1", "ISO_8859_1", "ISO8859_1", "ISO-8859-1", "ISO8859_1", "UTF8", "UTF8", "UTF-8", "UTF8", "UTF16", "UTF16", "UTF-16", "UTF16", "UTF32", "UTF32", "UTF-32", "UTF32", "ASCII", "ASCII", "ISO2022JP", "ISO2022JP", "ISO_2022_JP", "ISO2022JP", "ISO-2022-JP", "ISO2022JP", "EUC_JP", "EUC_JP", "EUC-JP", "EUC_JP", "Shift_JIS", "Shift_JIS", "SHIFT-JIS", "Shift_JIS", "SJIS", "Shift_JIS", "MS932", "MS932", "MS-932", "MS932", "MS_932", "MS932", "WINDOWS-31J", "Windows-31J", "WINDOWS_31J", "Windows-31J", "WINDOWS31J", "Windows-31J"};

    public static final String getCharset(String charset) {
        if (charset == null || charset.length() <= 0) {
            return null;
        }
        charset = charset.toUpperCase();
        int len = CONVERT_CODE.length;
        int i = 0;
        while (i < len) {
            if (charset.startsWith(CONVERT_CODE[i].toUpperCase())) {
                return CONVERT_CODE[i + 1];
            }
            i += 2;
        }
        return null;
    }
}

