package org.maachang.dbm ;

/**
 * 次キー内容取得用オブジェクト.
 * 
 * @version 2008/01/16
 * @author masahito suzuki
 * @since MaachangDBM 1.00
 */
public class MDbmDefine {
    
    /**
     * １ファイル内のセクタ管理数.
     */
    public static final int ONE_FILE_SECTOR = 524288 ;
    
    /**
     * Hashプロパティ名.
     */
    public static final String HASH_PROPERTY = "mdbm.hash" ;
    
    /**
     * Hashデフォルト値.
     */
    public static final int DEF_HASH= 20 ;
    
    /**
     * Hash最小値.
     */
    public static final int MIN_HASH= 18 ;
    
    /**
     * Hash最大値.
     */
    public static final int MAX_HASH= 26 ;
    
    /**
     * Keyプロパティ名.
     */
    public static final String KEY_PROPERTY = "mdbm.key" ;
    
    /**
     * Keyデフォルト値.
     */
    public static final int DEF_KEY= 256 ;
    
    /**
     * Key最小値.
     */
    public static final int MIN_KEY= 128 ;
    
    /**
     * Key最大値.
     */
    public static final int MAX_KEY= 1024 ;
    
    /**
     * Sectorプロパティ名.
     */
    public static final String SECTOR_PROPERTY = "mdbm.sector" ;
    
    /**
     * Sectorデフォルト値.
     */
    public static final int DEF_SECTOR= 1024 ;
    
    /**
     * Sector最小値.
     */
    public static final int MIN_SECTOR= 512 ;
    
    /**
     * Sector最大値.
     */
    public static final int MAX_SECTOR= 8192 ;
    
    /**
     * 最大件数プロパティ名.
     */
    public static final String LENGTH_PROPERTY = "mdbm.maxLength" ;
    
    /**
     * 最大件数デフォルト値.
     */
    public static final int DEF_LENGTH= 15000000 ;
    
    /**
     * 最大件数最小値.
     */
    public static final int MIN_LENGTH= 500000 ;
    
    /**
     * 最大件数最大値.
     */
    public static final int MAX_LENGTH= 50000000 ;

}
