package org.maachang.dbm ;

/**
 * MaachangDbmI/O.
 * 
 * @version 2008/04/16
 * @author masahito suzuki
 * @since MaachangDBM 1.09
 */
public interface MDbmIO {
    
    /**
     * 指定情報を最後の位置に追加.
     * <BR>
     * @param key 対象のキー情報を設定します.
     * @param value 対象の情報を設定します.
     * @param off 対象のオフセット値を設定します.
     * @param length 対象のデータ長を設定します.
     * @exception Exception 例外.
     */
    public void addLast( byte[] key,byte[] value,int off,int length )
        throws Exception ;
    
    /**
     * 指定位置の内容を書き込む.
     * <BR>
     * @param key 対象のキー情報を設定します.
     * @param value 対象の情報を設定します.
     * @param pos 対象のポジションを設定します.
     * @param off 対象のオフセット値を設定します.
     * @param length 対象のデータ長を設定します.
     * @return int 書き込まれたデータ長が返されます.
     * @exception Exception 例外.
     */
    public int write( byte[] key,byte[] value,int pos,int off,int length )
        throws Exception ;
    
    /**
     * 指定位置の内容を読み込む.
     * <BR>
     * @param key 対象のキー情報を設定します.
     * @param value 対象の情報を設定します.
     * @param pos 対象のポジションを設定します.
     * @param off 対象のオフセット値を設定します.
     * @param length 対象のデータ長を設定します.
     * @return int 取得されたデータ長が返されます.
     * @exception Exception 例外.
     */
    public int read( byte[] key,byte[] value,int pos,int off,int length )
        throws Exception ;
    
    /**
     * 情報長を取得.
     * <BR>
     * @param key 対象のキー情報を設定します.
     * @return int 対象の情報長が返されます.
     * @exception Exception 例外.
     */
    public int getLength( byte[] key ) throws Exception ;
}
