package org.maachang.dbm.engine ;

import java.io.IOException;

import org.maachang.util.ConvertParam;

/**
 * 子キー情報.
 * 
 * @version 2008/01/16
 * @author masahito suzuki
 * @since MaachangDBM 1.00
 */
public class MKeyChild {
    private boolean useKey = true ;
    private int hashCode = -1 ;
    private int beforeHashPos = -1 ;
    private int nextHashPos = -1 ;
    private int valueFileNo = -1 ;
    private int valueFilePos = -1 ;
    private int lastValueFileNo = -1 ;
    private int lastValueFilePos = -1 ;
    private int valueLength = -1 ;
    private int keyLength = -1 ;
    private byte[] key = null ;
    private int position = -1 ;
    
    public MKeyChild() {
        
    }
    
    public MKeyChild( int hashCode,int beforeHashPos,int nextHashPos,int valueFileNo,
        int valueFilePos,int lastValueFileNo,int lastValueFilePos,int valueLength,byte[] key ) {
        this.useKey = true ;
        this.hashCode = hashCode ;
        this.beforeHashPos = beforeHashPos ;
        this.nextHashPos = nextHashPos ;
        this.valueFileNo = valueFileNo ;
        this.valueFilePos = valueFilePos ;
        this.lastValueFileNo = lastValueFileNo ;
        this.lastValueFilePos = lastValueFilePos ;
        this.valueLength = valueLength ;
        this.key = key ;
        this.keyLength = key.length ;
    }
    
    public void setUseKey( boolean useKey ) {
        this.useKey = useKey ;
    }
    
    public boolean isUseKey() {
        return this.useKey ;
    }
    
    public void setHashCode( int hashCode ) {
        this.hashCode = hashCode ;
    }
    
    public int getHashCode() {
        return this.hashCode ;
    }
    
    public void setBeforeHashPos( int beforeHashPos ) {
        this.beforeHashPos = beforeHashPos ;
    }
    
    public int getBeforeHashPos() {
        return this.beforeHashPos ;
    }
    
    public void setNextHashPos( int nextHashPos ) {
        this.nextHashPos = nextHashPos ;
    }
    
    public int getNextHashPos() {
        return this.nextHashPos ;
    }
    
    public void setValueFileNo( int valueFileNo ) {
        this.valueFileNo = valueFileNo ;
    }
    
    public int getValueFileNo() {
        return this.valueFileNo ;
    }
    
    public void setValueFilePos( int valueFilePos ) {
        this.valueFilePos = valueFilePos ;
    }
    
    public int getValueFilePos() {
        return this.valueFilePos ;
    }
    
    public void setLastValueFileNo( int lastValueFileNo ) {
        this.lastValueFileNo = lastValueFileNo ;
    }
    
    public int getLastValueFileNo() {
        return this.lastValueFileNo ;
    }
    
    public void setLastValueFilePos( int lastValueFilePos ) {
        this.lastValueFilePos = lastValueFilePos ;
    }
    
    public int getLastValueFilePos() {
        return this.lastValueFilePos ;
    }
    
    public void setValueLength( int valueLength ) {
        this.valueLength = valueLength ;
    }
    
    public int getValueLength() {
        return this.valueLength ;
    }
    
    public int getKeyLength() {
        return this.keyLength ;
    }
    
    public void setKey( byte[] key ) {
        if( key == null || key.length <= 0 ) {
            return ;
        }
        this.key = key ;
        this.keyLength = key.length ;
    }
    
    public byte[] getKey() {
        return this.key ;
    }
    
    public void setPosition( int position ) {
        this.position = position ;
    }
    
    public int getPosition() {
        return position ;
    }
    
    public byte[] save() throws Exception {
        if( this.key == null || this.key.length <= 0 ) {
            throw new IOException( "Key情報は不正です" ) ;
        }
        byte[] ret = new byte[ MKey.KEY_HEADER_LENGTH + this.keyLength ] ;
        int pnt = 0 ;
        ConvertParam.convertBoolean( ret,pnt,this.useKey ) ;
        pnt += 1 ;
        ConvertParam.convertInt( ret,pnt,this.hashCode ) ;
        pnt += 4 ;
        ConvertParam.convertInt( ret,pnt,this.beforeHashPos ) ;
        pnt += 4 ;
        ConvertParam.convertInt( ret,pnt,this.nextHashPos ) ;
        pnt += 4 ;
        ConvertParam.convertShort( ret,pnt,( short )( this.valueFileNo & 0x0000ffff ) ) ;
        pnt += 2 ;
        ConvertParam.convertInt( ret,pnt,this.valueFilePos ) ;
        pnt += 4 ;
        ConvertParam.convertShort( ret,pnt,( short )( this.lastValueFileNo & 0x0000ffff ) ) ;
        pnt += 2 ;
        ConvertParam.convertInt( ret,pnt,this.lastValueFilePos ) ;
        pnt += 4 ;
        ConvertParam.convertInt( ret,pnt,this.valueLength ) ;
        pnt += 4 ;
        ConvertParam.convertShort( ret,pnt,( short )( keyLength & 0x0000ffff ) ) ;
        pnt += 2 ;
        System.arraycopy( this.key,0,ret,pnt,keyLength ) ;
        return ret ;
    }
    
    public static final MKeyChild load( byte[] binary ) throws Exception {
        if( binary == null || binary.length != MKey.KEY_LENGTH ) {
            throw new IOException( "指定バイナリは不正です" ) ;
        }
        int pnt = 0 ;
        MKeyChild ret = new MKeyChild() ;
        ret.useKey = ConvertParam.convertBoolean( pnt,binary ) ;
        pnt += 1 ;
        ret.hashCode = ConvertParam.convertInt( pnt,binary ) ;
        pnt += 4 ;
        ret.beforeHashPos = ConvertParam.convertInt( pnt,binary ) ;
        pnt += 4 ;
        ret.nextHashPos = ConvertParam.convertInt( pnt,binary ) ;
        pnt += 4 ;
        ret.valueFileNo = ( int )( ConvertParam.convertShort( pnt,binary ) & 0x000ffff ) ;
        ret.valueFileNo = ( ( ret.valueFileNo & 0xfffff400 ) != 0 ) ? -1 : ret.valueFileNo ;
        pnt += 2 ;
        ret.valueFilePos = ConvertParam.convertInt( pnt,binary ) ;
        pnt += 4 ;
        ret.lastValueFileNo = ( int )( ConvertParam.convertShort( pnt,binary ) & 0x000ffff ) ;
        ret.lastValueFileNo = ( ( ret.lastValueFileNo & 0xfffff400 ) != 0 ) ? -1 : ret.lastValueFileNo ;
        pnt += 2 ;
        ret.lastValueFilePos = ConvertParam.convertInt( pnt,binary ) ;
        pnt += 4 ;
        ret.valueLength = ConvertParam.convertInt( pnt,binary ) ;
        pnt += 4 ;
        ret.keyLength = ( int )( ConvertParam.convertShort( pnt,binary ) & 0x0000ffff ) ;
        pnt += 2 ;
        ret.key = new byte[ ret.keyLength ] ;
        System.arraycopy( binary,pnt,ret.key,0,ret.keyLength ) ;
        return ret ;
    }
}
