/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.maachang.dbm.engine.M2Buffers;
import org.maachang.dbm.engine.M2Flag;
import org.maachang.dbm.engine.M2Rand;
import org.maachang.dbm.engine.M2SectorHeader;
import org.maachang.dbm.engine.M2SyncTimeoutException;
import org.maachang.dbm.engine.M2WriteSync;
import org.maachang.dbm.engine.MDbmEnv;
import org.maachang.util.ConvertParam;
import org.maachang.util.FileUtil;

class M2OneFileSector {
    public static final int MAX_ONE_FILE = 3500000;
    public static final int FULL_SYNC_SIZE = MDbmEnv.FULL_SYNC_SIZE;
    public static final String SECTOR_PLUS = ".sct2";
    private static final int ONE_SECTOR = MDbmEnv.SECTOR;
    private static final long SECTOR_OFFSET = 12L;
    private static final long READ_TIMEOUT = 15000L;
    private static final long WRITE_TIMEOUT = 30000L;
    private static final int FIRST_SECTOR = 8192;
    private static final double CONST_ADD = 0.75;
    private M2Flag flags = null;
    private M2Rand randIo = null;
    private int fileNo = -1;
    private long startSectorPos = -1L;
    private M2Buffers readBuf = null;
    private M2Buffers writeBuf = null;
    private long nowFileSize = 0L;
    private int nextAdd = 0;
    private M2WriteSync m2WriteSync = null;
    private Object syncWrite = null;

    private M2OneFileSector() {
    }

    public M2OneFileSector(int fileNo, String dir, int size, Object syncWrite, M2Buffers readBuf, M2Buffers writeBuf) throws Exception {
        M2Flag flg;
        String name;
        if (fileNo <= -1 || dir == null || (dir = dir.trim()).length() <= 0 || size <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!FileUtil.isDirExists((String)dir)) {
            throw new IllegalArgumentException("\u6307\u5b9a\u30c7\u30a3\u30ec\u30af\u30c8\u30ea[" + dir + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (size >= 3500000) {
            size = 3500000;
        }
        if (!dir.endsWith("/") && !dir.endsWith("\\")) {
            dir = String.valueOf(dir) + "/";
        }
        boolean newFile = !FileUtil.isFileExists((String)(name = dir + fileNo + SECTOR_PLUS));
        long startPos = M2Flag.convertRect(size);
        M2Rand rnd = null;
        rnd = newFile ? new M2Rand(name, ((long)ONE_SECTOR + 12L) * 8192L + startPos) : new M2Rand(name);
        this.flags = flg = new M2Flag(newFile, rnd.getRandomAccessFile(), 0, size);
        this.randIo = rnd;
        this.fileNo = fileNo;
        this.startSectorPos = startPos;
        this.readBuf = readBuf;
        this.writeBuf = writeBuf;
        this.nowFileSize = this.randIo.getLength();
        this.nextAdd = this.nextAddSize(this.nowFileSize);
        this.m2WriteSync = new M2WriteSync(size);
        this.syncWrite = syncWrite;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.flags != null) {
            this.flags.clear();
        }
        this.flags = null;
        if (this.randIo != null) {
            this.randIo.destroy();
        }
        if (this.m2WriteSync != null) {
            this.m2WriteSync.destroy();
        }
        this.randIo = null;
        this.fileNo = -1;
        this.startSectorPos = -1L;
        this.readBuf = null;
        this.writeBuf = null;
        this.nowFileSize = -1L;
        this.nextAdd = -1;
        this.m2WriteSync = null;
    }

    public int getPos() throws Exception {
        return this.flags.usePosBySet(0);
    }

    public void removePos(int no) throws Exception {
        this.flags.removePos(no);
    }

    public void read(M2SectorHeader outHeader, byte[] out, int no) throws Exception {
        this.read(outHeader, out, no, 0);
    }

    public void read(M2SectorHeader outHeader, byte[] out, int no, int offset) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        outHeader.clear();
        if (no >= 0) {
            long seek = ((long)ONE_SECTOR + 12L) * (long)no + this.startSectorPos;
            ByteBuffer rbuf = this.getUseBuffer(this.readBuf);
            if (rbuf != null) {
                try {
                    rbuf.clear();
                    this.syncWrite(false, no);
                    if (!this.isUse()) {
                        throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
                    }
                    int len = this.randIo.read(rbuf, seek);
                    if ((long)len != (long)ONE_SECTOR + 12L) {
                        throw new IOException("\u6307\u5b9a\u9805\u756a[" + no + "]\u306f\u4e0d\u6b63\u3067\u3059");
                    }
                    byte[] temp = new byte[4];
                    rbuf.get(temp, 0, 4);
                    outHeader.setNextNo(ConvertParam.convertInt((int)0, (byte[])temp));
                    rbuf.get(temp, 0, 4);
                    outHeader.setNextFileNo(ConvertParam.convertInt((int)0, (byte[])temp));
                    rbuf.get(temp, 0, 4);
                    outHeader.setLength(ConvertParam.convertInt((int)0, (byte[])temp));
                    if (outHeader.getLength() > 0) {
                        rbuf.get(out, offset, outHeader.getLength());
                    }
                }
                finally {
                    if (this.isUse()) {
                        rbuf.clear();
                        this.readBuf.append(rbuf);
                    }
                }
            }
        }
    }

    public void writeTo(boolean mode, M2SectorHeader header, byte[] in, int no) throws Exception {
        this.writeTo(mode, header, in, no, 0);
    }

    public void writeTo(boolean mode, M2SectorHeader header, byte[] in, int no, int offset) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (no >= 0) {
            long seek = ((long)ONE_SECTOR + 12L) * (long)no + this.startSectorPos;
            ByteBuffer wbuf = this.getUseBuffer(this.writeBuf);
            if (wbuf != null) {
                try {
                    wbuf.clear();
                    this.plus(no);
                    wbuf.put(ConvertParam.convertInt((int)header.getNextNo()));
                    wbuf.put(ConvertParam.convertInt((int)header.getNextFileNo()));
                    wbuf.put(ConvertParam.convertInt((int)header.getLength()));
                    if (header.getLength() > 0) {
                        wbuf.put(in, offset, header.getLength());
                    }
                    this.randIo.write(wbuf, seek, this.syncWrite);
                }
                finally {
                    if (this.isUse()) {
                        if (mode) {
                            try {
                                this.m2WriteSync.off(no);
                            }
                            catch (Exception exception) {}
                        }
                        wbuf.clear();
                        this.writeBuf.append(wbuf);
                    }
                }
            }
        }
    }

    protected boolean syncWrite(boolean mode, int no) throws Exception {
        if (no >= 0 && this.isUse()) {
            long time = System.currentTimeMillis();
            if (!mode) {
                while (true) {
                    if (!this.isUse()) {
                        throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
                    }
                    if (this.m2WriteSync == null || !this.m2WriteSync.flag(no)) break;
                    if (time + 15000L <= System.currentTimeMillis()) {
                        throw new M2SyncTimeoutException("timeout");
                    }
                    Thread.sleep(1L);
                }
                return true;
            }
            while (true) {
                if (!this.isUse()) {
                    throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
                }
                if (this.m2WriteSync == null || !this.m2WriteSync.flag(no)) break;
                if (time + 30000L <= System.currentTimeMillis()) {
                    throw new M2SyncTimeoutException("timeout");
                }
                Thread.sleep(1L);
            }
            return this.m2WriteSync.size() < FULL_SYNC_SIZE;
        }
        throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u308b\u304b\u3001\u6761\u4ef6\u304c\u4e0d\u6b63\u3067\u3059[" + no + "]");
    }

    protected void onSync(int no) throws Exception {
        if (no >= 0 && this.isUse()) {
            this.m2WriteSync.on(no);
        }
    }

    protected void offSync(int no) throws Exception {
        if (no >= 0 && this.isUse()) {
            this.m2WriteSync.off(no);
        }
    }

    public String getName() {
        return this.randIo.getName();
    }

    public synchronized int getFileNo() {
        return this.fileNo;
    }

    public int getSize() throws Exception {
        return this.flags.size();
    }

    public int getMax() throws Exception {
        return this.flags.maxSize();
    }

    private int nextAddSize(long now) {
        return (int)((double)((now - this.startSectorPos) / ((long)ONE_SECTOR + 12L)) * 0.75);
    }

    private void plus(int no) throws Exception {
        if (this.nextAdd >= this.flags.maxSize()) {
            return;
        }
        if (no >= this.nextAdd) {
            int now;
            this.nextAdd *= 2;
            if (this.nextAdd >= this.flags.maxSize()) {
                this.nextAdd = this.flags.maxSize();
            }
            if ((now = (int)((this.nowFileSize - this.startSectorPos) / ((long)ONE_SECTOR + 12L))) < this.nextAdd) {
                this.randIo.expansion((long)(this.nextAdd - now) * ((long)ONE_SECTOR + 12L), this.syncWrite);
                this.nowFileSize = this.randIo.getLength();
            }
        }
    }

    private synchronized boolean isUse() {
        return this.randIo != null;
    }

    private ByteBuffer getUseBuffer(M2Buffers buf) throws Exception {
        ByteBuffer ret = null;
        while (true) {
            if (!this.isUse()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            ret = buf.getQueue();
            if (ret != null) {
                return ret;
            }
            Thread.sleep(1L);
        }
    }
}

