/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.maachang.util.FileUtil;

class M2Rand {
    private String name = null;
    private RandomAccessFile rfp = null;
    private FileChannel channel = null;
    private long length = -1L;

    private M2Rand() {
    }

    public M2Rand(String name) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!FileUtil.isFileExists((String)name)) {
            throw new IOException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb\u540d[" + name + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        this.rfp = new RandomAccessFile(name, "rwd");
        this.channel = this.rfp.getChannel();
        this.name = name;
        this.length = (int)this.rfp.length();
    }

    public M2Rand(String name, long size) throws Exception {
        if (size <= 0L || name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.rfp = new RandomAccessFile(name, "rwd");
        if (FileUtil.isFileExists((String)name)) {
            this.rfp.setLength(0L);
        }
        this.rfp.setLength(size);
        this.channel = this.rfp.getChannel();
        this.name = name;
        this.length = (int)this.rfp.length();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.rfp != null) {
            try {
                this.channel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.rfp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.rfp = null;
        this.channel = null;
        this.name = null;
        this.length = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void expansion(long size, Object syncWrite) throws Exception {
        long newLen;
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (size <= 0L) {
            return;
        }
        this.length = newLen = this.length + size;
        Object object = syncWrite;
        synchronized (object) {
            this.rfp.setLength(newLen);
        }
    }

    public int read(ByteBuffer buf, long seek) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        int ret = this.channel.read(buf, seek);
        buf.flip();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ByteBuffer buf, long seek, Object syncWrite) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        buf.flip();
        Object object = syncWrite;
        synchronized (object) {
            this.channel.write(buf, seek);
        }
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized long getLength() {
        return this.length;
    }

    public synchronized RandomAccessFile getRandomAccessFile() {
        return this.rfp;
    }

    protected synchronized boolean isUse() {
        return this.channel != null;
    }
}

