package org.maachang.dbm.engine ;

import java.nio.ByteBuffer;
import java.util.LinkedList;

/**
 * 読み込みバッファ管理.
 * 
 * @version 2008/06/05
 * @author masahito suzuki
 * @since MaachangDBM 1.12
 */
class M2Buffers {
    private LinkedList<ByteBuffer> queue = null ;
    
    public M2Buffers( int size,int bufferLength ) {
        queue = new LinkedList<ByteBuffer>() ;
        for( int i = 0 ; i < bufferLength ; i ++ ) {
            queue.add( ByteBuffer.allocateDirect( size ) ) ;
            //queue.add( ByteBuffer.allocate( size ) ) ;
        }
    }
    
    public synchronized void destroy() {
        if( queue != null ) {
            queue.clear() ;
        }
    }
    
    public synchronized void append( ByteBuffer element ) {
        if( element == null || element == null ) {
            return ;
        }
        queue.add( element ) ;
    }
    
    public synchronized ByteBuffer getQueue() {
        if( queue == null || queue.size() <= 0 ) {
            return null ;
        }
        return queue.removeFirst() ;
    }
    
    public synchronized int size() {
        return queue.size() ;
    }
}
