package org.maachang.dbm.engine ;

import java.util.HashSet;

/**
 * 指定キーでロック処理.
 * 
 * @version 2008/06/05
 * @author masahito suzuki
 * @since MaachangDBM 1.12
 */
class M2Lock {
    
    /**
     * ロックスリープ時間.
     */
    private static final long SLEEP_TIME = 5L ;
    
    /**
     * ロック名群.
     */
    private HashSet<Integer> manager = null ;
    
    /**
     * コンストラクタ.
     */
    public M2Lock() {
        manager = new HashSet<Integer>() ;
    }
    
    /**
     * 指定名でロック.
     * @param code Hashコードを設定します.
     * @exceptino InterruptedException スレッド割り込み例外.
     */
    public void lock( int code ) throws InterruptedException {
        Integer key = new Integer( code & MDbmEnv.HASH ) ;
        for( ;; ) {
            synchronized( this ) {
                if( manager.contains( key ) == false ) {
                    manager.add( key ) ;
                    break ;
                }
            }
            Thread.sleep( SLEEP_TIME ) ;
        }
    }
    
    /**
     * 指定名でアンロック.
     * @param code Hashコードを設定します.
     */
    public void unlock( int code ) {
        Integer key = new Integer( code & MDbmEnv.HASH ) ;
        synchronized( this ) {
            manager.remove( key ) ;
        }
    }
}
