package org.maachang.dbm.engine ;

/**
 * １つのセクタヘッダ.
 * 
 * @version 2008/06/05
 * @author masahito suzuki
 * @since MaachangDBM 1.12
 */
class M2SectorHeader {
    
    /**
     * 次の書き込み項番.
     */
    protected int nextNo = -1 ;
    
    /**
     * 次の書き込み項番(ファイルNo).
     */
    protected int nextFileNo = -1 ;
    
    /**
     * １セクタのデータ長.
     */
    protected int length = -1 ;
    
    /**
     * コンストラクタ.
     */
    public M2SectorHeader() {
        
    }
    
    /**
     * コンストラクタ.
     */
    public M2SectorHeader( int nextNo,int nextFileNo,int length ) {
        this.nextNo = nextNo ;
        this.nextFileNo = nextFileNo ;
        this.length = length ;
    }
    
    /**
     * 情報クリア.
     */
    public void clear() {
        nextNo = -1 ;
        nextFileNo = -1 ;
        length = -1 ;
    }
    
    /**
     * length を取得.
     * <BR><BR>
     * @return length が返されます.
     */
    public int getLength() {
        return length;
    }
    
    /**
     * length を設定.
     * <BR><BR>
     * @param length length を設定します.
     */
    public void setLength(int length) {
        this.length = length;
    }
    
    /**
     * nextFileNo を取得.
     * <BR><BR>
     * @return nextFileNo が返されます.
     */
    public int getNextFileNo() {
        return nextFileNo;
    }
    
    /**
     * nextFileNo を設定.
     * <BR><BR>
     * @param nextFileNo nextFileNo を設定します.
     */
    public void setNextFileNo(int nextFileNo) {
        this.nextFileNo = nextFileNo;
    }
    
    /**
     * nextNo を取得.
     * <BR><BR>
     * @return nextNo が返されます.
     */
    public int getNextNo() {
        return nextNo;
    }
    
    /**
     * nextNo を設定.
     * <BR><BR>
     * @param nextNo nextNo を設定します.
     */
    public void setNextNo(int nextNo) {
        this.nextNo = nextNo;
    }
    
    /**
     * オブジェクトコピー.
     */
    public void copyObject( M2SectorHeader object ) {
        object.nextNo = this.nextNo ;
        object.nextFileNo = this.nextFileNo ;
        object.length = this.length ;
    }
    
    public String toString() {
        return new StringBuilder().
            append( " nextNo:" ).append( nextNo ).
            append( " nextFileNo:" ).append( nextFileNo ).
            append( " length:" ).append( length ).toString() ;
    }
}
