package org.maachang.dbm.engine ;

/**
 * セクタ書き込み要素.
 * 
 * @version 2008/06/05
 * @author masahito suzuki
 * @since MaachangDBM 1.12
 */
class M2WriteElement {
    
    /**
     * 書き込み先セクタファイルオブジェクト.
     */
    private M2OneFileSector sectorObject = null ;
    
    /**
     * セクタヘッダ.
     */
    private M2SectorHeader header = null ;
    
    /**
     * 書き込みデータ.
     */
    private byte[] data = null ;
    
    /**
     * 書き込みセクタ位置.
     */
    private int no = -1 ;
    
    /**
     * 書き込みデータオフセット値.
     */
    private int offset = -1 ;
    
    /**
     * コンストラクタ.
     */
    private M2WriteElement() {
        
    }
    
    /**
     * コンストラクタ.
     * @param sectorObject 書き込み先セクタオブジェクトを設定します.
     * @param header 書き込みセクタ情報を設定します.
     * @param data 書き込みデータを設定します.
     * @param no 書き込みセクタ位置を設定します.
     * @param offset 書き込みセクタオフセット値を設定します.
     */
    public M2WriteElement( M2OneFileSector sectorObject,M2SectorHeader header,
        byte[] data,int no,int offset ) {
        this.sectorObject = sectorObject ;
        this.header = header ;
        this.data = data ;
        this.no = no ;
        this.offset = offset ;
    }
    
    /**
     * 情報クリア.
     */
    public void clear() {
        this.sectorObject = null ;
        this.header = null ;
        this.data = null ;
    }
    
    /**
     * data を取得.
     * <BR><BR>
     * @return data が返されます.
     */
    public byte[] getData() {
        return data;
    }
    
    /**
     * header を取得.
     * <BR><BR>
     * @return header が返されます.
     */
    public M2SectorHeader getHeader() {
        return header;
    }
    
    /**
     * no を取得.
     * <BR><BR>
     * @return no が返されます.
     */
    public int getNo() {
        return no;
    }
    
    /**
     * offset を取得.
     * <BR><BR>
     * @return offset が返されます.
     */
    public int getOffset() {
        return offset;
    }
    
    /**
     * sectorObject を取得.
     * <BR><BR>
     * @return sectorObject が返されます.
     */
    public M2OneFileSector getSectorObject() {
        return sectorObject;
    }
}
