package org.maachang.dbm.engine ;

import java.util.LinkedList;

/**
 * 書込みデータキュー.
 * 
 * @version 2008/06/05
 * @author masahito suzuki
 * @since MaachangDBM 1.12
 */
class M2WriteQueue {
    private LinkedList<M2WriteElement> queue = null ;
    
    public M2WriteQueue() {
        queue = new LinkedList<M2WriteElement>() ;
    }
    
    public synchronized void destroy() {
        if( queue != null ) {
            queue.clear() ;
        }
    }
    
    public synchronized void append( M2WriteElement element ) {
        if( element == null || element == null ) {
            return ;
        }
        queue.add( element ) ;
    }
    
    public synchronized M2WriteElement getQueue() {
        if( queue == null || queue.size() <= 0 ) {
            return null ;
        }
        return queue.removeFirst() ;
    }
    
    public synchronized int size() {
        return queue.size() ;
    }
}
