package org.maachang.dbm.engine ;

import java.io.IOException;

/**
 * 書込み同期フラグ.
 * 
 * @version 2008/06/05
 * @author masahito suzuki
 * @since MaachangDBM 1.12
 */
class M2WriteSync {
    private static final int ETC_MASK = 0x0000003f ;
    private static final long LETC_MASK = ( ( long )ETC_MASK & 0x00000000ffffffffL ) ;
    private static final int FSS_MASK = ~ETC_MASK ;
    private static final int RIGHT_SHIFT = 6 ;
    private long[] sync = null ;
    private int waitSize = 0 ;
    
    private M2WriteSync() {
        
    }
    
    public M2WriteSync( int size ) {
        this.sync = new long[ convert( size ) ] ;
    }
    
    protected void finalize() throws Exception {
        destroy() ;
    }
    
    public synchronized void destroy() {
        sync = null ;
    }
    
    private static final int convert( int size ) {
        return ( ( ( size & FSS_MASK ) >> RIGHT_SHIFT ) + ( ( ( size & ETC_MASK ) != 0 ) ? 1 : 0 ) ) ;
    }
    
    public void on( int no ) throws Exception {
        long pos = ( long )no & 0x00000000ffffffffL ;
        int thisPos = ( ( no & FSS_MASK ) >> RIGHT_SHIFT ) ;
        long innerPos = ( pos & LETC_MASK ) ;
        synchronized( this ) {
            long target = sync[ thisPos ] ;
            if( ( ( ( 1L << innerPos ) ) & target ) != 0L ) {
                throw new IOException( "指定項番["+pos+"]は既にONです" ) ;
            }
            sync[ thisPos ] = ( 1L << innerPos ) | target ;
            waitSize ++ ;
        }
    }
    
    public void off( int no ) {
        long pos = ( long )no & 0x00000000ffffffffL ;
        int thisPos = ( ( no & FSS_MASK ) >> RIGHT_SHIFT ) ;
        long innerPos = ( pos & LETC_MASK ) ;
        synchronized( this ) {
            long target = sync[ thisPos ] ;
            if( ( ( ( 1L << innerPos ) ) & target ) == 0L ) {
                return ;
            }
            sync[ thisPos ] = ( ~( 1L << innerPos ) ) & target ;
            waitSize -- ;
            if( waitSize <= 0 ) {
                waitSize = 0 ;
            }
        }
    }
    
    public boolean flag( int no ) {
        long pos = ( long )no & 0x00000000ffffffffL ;
        int thisPos = ( ( no & FSS_MASK ) >> RIGHT_SHIFT ) ;
        long innerPos = ( pos & LETC_MASK ) ;
        synchronized( this ) {
            long target = sync[ thisPos ] ;
            return ( ( ( ( 1L << innerPos ) ) & target ) != 0L ) ;
        }
    }
    
    public synchronized int size() {
        return waitSize ;
    }

}
