package org.maachang.dbm.engine ;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.util.thread.LoopThread;

/**
 * セクタ書き込み用スレッド.
 * 
 * @version 2008/06/05
 * @author masahito suzuki
 * @since MaachangDBM 1.12
 */
class M2WriteThread extends LoopThread {
    
    /**
     * ログオブジェクト.
     */
    private static final Log logOut = LogFactory.getLog( M2WriteThread.class ) ;
    
    /**
     * キューオブジェクト.
     */
    private M2WriteQueue queue = null ;
    
    /**
     * コンストラクタ.
     */
    private M2WriteThread() {
        
    }
    
    /**
     * コンストラクタ.
     * @param queue 対象のキューを設定します.
     * @exception Exception 例外.
     */
    public M2WriteThread( M2WriteQueue queue )
        throws Exception {
        this.queue = queue ;
        this.startThread() ;
    }
    
    /**
     * デストラクタ.
     */
    protected void finalize() throws Exception {
        this.destroy() ;
    }
    
    /**
     * オブジェクト破棄.
     */
    public void destroy() {
        super.stopThread() ;
    }
    
    /**
     * オブジェクトクリア処理.
     * <p>スレッドが停止したときに呼び出されます.</p>
     */
    protected void clear() {
        this.queue = null ;
    }
    
    /**
     * 実行処理.
     * <p>スレッド実行を行う実装を行います.</p>
     * @return boolean [false]の場合、Thread.sleep(30)が発生します.
     * @exception Exception 例外.
     */
    protected boolean execution() throws Exception {
        M2WriteElement element = queue.getQueue() ;
        try {
            if( element == null ) {
                Thread.sleep( 1L ) ;
                return true ;
            }
            element.getSectorObject().writeTo( true,
                element.getHeader(),
                element.getData(),
                element.getNo(),
                element.getOffset() ) ;
            return true ;
        } catch( Exception e ) {
            // エラー出力.
            if( MDbmDefine.OUT_MODE == true ) {
                logOut.error( "## error - fileNo:" + element.getSectorObject().getFileNo() +
                    " pos:" + element.getNo() + " offset:" + element.getOffset() +
                    " length:" + element.getHeader().getLength() + " dataLength:" + 
                    ( ( element.getData() == null ) ? "0" : element.getData().length ) ,e ) ;
            }
            throw e ;
        }
    }
    
}
