package org.maachang.dbm.engine ;

/**
 * 次キー内容取得用オブジェクト.
 * 
 * @version 2008/01/16
 * @author masahito suzuki
 * @since MaachangDBM 1.00
 */
public class MDbmDefine {
    
    /**
     * MDBMバージョン.
     */
    public static final String VERSION = "b1.12" ;
    
    /**
     * シーケンスサイズ.
     */
    public static final int MAX_SEQUENCE_ID = 64 ;
    
    /**
     * セクタヘッダ.
     */
    public static final int SECTOR_HEADER = 12 ;
    
    /**
     * 初期化ログ出力モード.
     */
    public static boolean OUT_MODE = true ;
    
    /**
     * Hashプロパティ名.
     */
    public static final String HASH_PROPERTY = "mdbm.hash" ;
    
    /**
     * Hashデフォルト値.
     */
    public static final int DEF_HASH= 20 ;
    
    /**
     * Hash最小値.
     */
    public static final int MIN_HASH= 8 ;
    
    /**
     * Hash最大値.
     */
    public static final int MAX_HASH= 26 ;
    
    /**
     * 1ファイルで管理できるセクタプロパティ名.
     */
    public static final String ONE_FILE_SECTOR_PROPERTY = "mdbm.sector.file" ;
    
    /**
     * 1ファイルで扱えるデフォルトセクタ数.
     */
    public static final int DEF_ONE_FILE_SECTOR= 500000 ;
    
    /**
     * 1ファイルで扱える最小セクタ数.
     */
    public static final int MIN_ONE_FILE_SECTOR= 10000 ;
    
    /**
     * 1ファイルで扱える最大セクタ数.
     */
    public static final int MAX_ONE_FILE_SECTOR= 3500000 ;
    
    /**
     * セクタ数プロパティ.
     */
    public static final String ONE_SECTOR_PROPERTY = "mdbm.sector" ;
    
    /**
     * デフォルトセクタ数
     */
    public static final int DEF_ONE_SECTOR = 512-SECTOR_HEADER ;
    
    /**
     * 最小セクタ数.
     */
    public static final int MIN_ONE_SECTOR= 255-SECTOR_HEADER ;
    
    /**
     * 最大セクタ数.
     */
    public static final int MAX_ONE_SECTOR= 4096-SECTOR_HEADER ;
    
    /**
     * セクタ書込み非同期スレッド数プロパティ.
     */
    public static final String ASYNC_WRITE_THREAD_PROPERTY = "mdbm.async" ;
    
    /**
     * デフォルトセクタ書込み非同期スレッド数.
     */
    public static final int DEF_ASYNC_WRITE = 15 ;
    
    /**
     * 最小セクタ書込み非同期スレッド数.
     */
    public static final int MIN_ASYNC_WRITE = 3 ;
    
    /**
     * 最大セクタ書込み非同期スレッド数.
     */
    public static final int MAX_ASYNC_WRITE = 50 ;
    
    /**
     * 非同期書込みデータ最大数プロパティ.
     */
    public static final String FULL_SYNC_SIZE_PROPERTY = "mdbm.async.full" ;
    
    /**
     * デフォルト非同期書込みデータ最大数.
     */
    public static final int DEF_FULL_SYNC_SIZE = 1024 ;
    
    /**
     * 最小非同期書込みデータ最大数.
     */
    public static final int MIN_FULL_SYNC_SIZE = 64 ;
    
    /**
     * 最大非同期書込みデータ最大数.
     */
    public static final int MAX_FULL_SYNC_SIZE = 32767 ;
    
    /**
     * バッファキャッシュ数プロパティ.
     */
    public static final String BUFFERS_SIZE_PROPERTY = "mdbm.buffers" ;
    
    /**
     * デフォルトバッファキャッシュ数.
     */
    public static final int DEF_BUFFERS_SIZE = 15 ;
    
    /**
     * 最小バッファキャッシュ数.
     */
    public static final int MIN_BUFFERS_SIZE = 5 ;
    
    /**
     * 最大バッファキャッシュ数.
     */
    public static final int MAX_BUFFERS_SIZE = 50 ;
}
