package org.maachang.dbm.engine ;

import org.maachang.util.ConvertParam;
import org.maachang.util.FileUtil;

/**
 * MDbmEngineUtil.
 * 
 * @version 2008/05/23
 * @author masahito suzuki
 * @since MaachangDBM 1.0D
 */
public class MDbmEngineUtil {
    
    /**
     * バージョンファイル名.
     */
    private static final String VERSION_FILE = ".version" ;
    
    /**
     * セクタサイズから、詳細の値までを取得.
     * @param size セクタサイズを設定します.
     * @return int[] [1:整形されたセクタ数,2:セクタシフト値].
     */
    public static final int[] getSector( int size ) {
        int shift = -1 ;
        int befSize = -1 ;
        for( int i = 1 ; i < 32 ; i ++ ) {
            int x = 1 << i ;
            x = x - 1 ;
            if( size >= x ) {
                befSize = x ;
                shift = i ;
            }
            else {
                break ;
            }
        }
        return new int[]{ befSize,shift } ;
    }
    
    /**
     * MDbmバージョンチェック.
     * @param dir 対象のディレクトリ名を設定します.
     * @return boolean [true]の場合、バージョン不正です.
     * @exception Exception 例外.
     */
    public static final boolean isMDbmVersion( String dir )
        throws Exception {
        if( dir == null || ( dir = dir.trim() ).length() <= 0 ) {
            throw new IllegalArgumentException( "ディレクトリ名は不正です" ) ;
        }
        if( dir.endsWith( "/" ) == false && dir.endsWith( "\\" ) == false ) {
            dir += "/" ;
        }
        // ディレクトリが存在しない場合は、新規作成.
        if( FileUtil.isDirExists( dir ) == false ) {
            FileUtil.mkdirs( dir ) ;
        }
        String name = dir + VERSION_FILE ;
        // ヴァージョンファイルが存在しない場合は、新規作成.
        if( FileUtil.isFileExists( name ) == false ) {
            byte[] bin = new byte[ 4 * 3 ] ;
            int p = 0 ;
            ConvertParam.convertInt( bin,p,MDbmEnv.HASH ) ;
            p += 4 ;
            ConvertParam.convertInt( bin,p,MDbmEnv.ONE_SECTOR_BY_SECTOR_SIZE ) ;
            p += 4 ;
            ConvertParam.convertInt( bin,p,MDbmEnv.SECTOR ) ;
            p += 4 ;
            FileUtil.setFile( name,bin ) ;
        }
        else {
            byte[] bin = FileUtil.getFile( name ) ;
            int p = 0 ;
            if( ConvertParam.convertInt( p,bin ) != MDbmEnv.HASH ) {
                return true ;
            }
            p += 4 ;
            if( ConvertParam.convertInt( p,bin ) != MDbmEnv.ONE_SECTOR_BY_SECTOR_SIZE ) {
                return true ;
            }
            p += 4 ;
            if( ConvertParam.convertInt( p,bin ) != MDbmEnv.SECTOR ) {
                return true ;
            }
        }
        return false ;
    }
}
