/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rawio.async;

import java.io.IOException;
import org.maachang.rawio.Baseio;
import org.maachang.rawio.Rawio;
import org.maachang.rawio.RawioInstance;
import org.maachang.rawio.async.ASyncElement;
import org.maachang.rawio.async.ASyncFactory;
import org.maachang.rawio.async.ASyncQueue;
import org.maachang.rawio.async.ASyncWriteLock;

class ASyncio
implements Baseio {
    private ASyncFactory factory = null;
    private ASyncQueue queue = null;
    private int maxAsyncLength = -1;
    private Rawio rawio = null;
    private ASyncWriteLock lock = null;
    private int sectorSize = 0;

    private ASyncio() {
    }

    public ASyncio(long mode, ASyncFactory factory, ASyncQueue queue, int maxAsyncLength, String name) throws Exception {
        if (factory.isStop()) {
            throw new IOException("Factory\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u505c\u6b62\u3057\u3066\u3044\u307e\u3059");
        }
        Rawio rw = null;
        rw = mode == 0L ? (Rawio)RawioInstance.open(name) : (mode == 1L ? (Rawio)RawioInstance.openDirect(name) : (mode == 2L ? (Rawio)RawioInstance.openEmulation(name) : (Rawio)RawioInstance.open(name)));
        ASyncWriteLock lk = new ASyncWriteLock(rw.length());
        this.factory = factory;
        this.queue = queue;
        this.maxAsyncLength = maxAsyncLength;
        this.rawio = rw;
        this.lock = lk;
        this.sectorSize = rw.getSector();
    }

    protected synchronized void destroy() {
        if (this.rawio != null) {
            this.rawio.destroy();
        }
        if (this.lock != null) {
            this.lock.destroy();
        }
        this.rawio = null;
        this.lock = null;
        this.queue = null;
        this.factory = null;
        this.maxAsyncLength = -1;
        this.sectorSize = 0;
    }

    public synchronized void flush() throws Exception {
        if (this.rawio != null) {
            this.rawio.flush();
        }
    }

    public synchronized void expansion(int size) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (size <= 0) {
            return;
        }
        this.rawio.expansion(size);
        this.lock.expansion(this.rawio.length());
    }

    public synchronized int getSector() {
        if (!this.isUse()) {
            return -1;
        }
        return this.sectorSize;
    }

    public synchronized String getName() {
        if (!this.isUse()) {
            return null;
        }
        return this.rawio.getName();
    }

    public synchronized int length() {
        if (!this.isUse()) {
            return -1;
        }
        return this.rawio.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read(int no) throws Exception {
        Rawio raw;
        int sec;
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        ASyncio aSyncio = this;
        synchronized (aSyncio) {
            sec = this.sectorSize;
            raw = this.rawio;
        }
        if (no < 0 || no > raw.length()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] ret = new byte[sec];
        this.waitToRead(ret, no);
        return ret;
    }

    public void read(byte[] out, int no) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (out == null || out.length != this.sectorSize || no < 0 || no >= this.rawio.length()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.waitToRead(out, no);
    }

    public void write(byte[] in, int no) throws Exception {
        this.write(false, in, no);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(boolean mode, byte[] in, int no) throws Exception {
        byte[] b;
        ASyncQueue q;
        ASyncWriteLock lk;
        Rawio raw;
        int sec;
        int max;
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (in == null || no < 0 || no >= this.rawio.length()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        ASyncio aSyncio = this;
        synchronized (aSyncio) {
            max = this.maxAsyncLength;
            sec = this.sectorSize;
            raw = this.rawio;
            lk = this.lock;
            q = this.queue;
        }
        if (mode) {
            if (in.length != sec) {
                throw new IOException("\u66f8\u8fbc\u307f\u30d0\u30a4\u30ca\u30ea\u9577\u306f\u4e0d\u6b63\u3067\u3059");
            }
            b = in;
        } else {
            b = new byte[sec];
            if (in.length > 0) {
                int len = in.length;
                if (len >= sec) {
                    len = sec;
                }
                System.arraycopy(in, 0, b, 0, len);
            }
        }
        boolean syncWriteFlag = false;
        while (true) {
            if (!this.isUse()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            ASyncio aSyncio2 = this;
            synchronized (aSyncio2) {
                if (!this.lock.flag(no)) {
                    if (max >= this.queue.elementSize()) {
                        lk.on(no);
                        break;
                    }
                    lk.on(no);
                    syncWriteFlag = true;
                }
            }
            if (syncWriteFlag) {
                try {
                    try {
                        raw.write(b, no);
                    }
                    catch (Exception exception) {}
                }
                finally {
                    lk.off(no);
                }
                return;
            }
            Thread.sleep(1L);
        }
        q.append(new ASyncElement(raw, lk, b, no));
    }

    public int getType() {
        return 1;
    }

    private synchronized boolean isUse() {
        return this.rawio != null && !this.factory.isStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitToRead(byte[] out, int no) throws Exception {
        Rawio raw;
        ASyncio aSyncio = this;
        synchronized (aSyncio) {
            raw = this.rawio;
        }
        while (true) {
            if (!this.isUse()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            aSyncio = this;
            synchronized (aSyncio) {
                if (!this.lock.flag(no)) {
                    break;
                }
            }
            Thread.sleep(1L);
        }
        raw.read(out, no);
    }
}

