package org.maachang.rawio ;

/**
 * I/O基本インターフェイス.
 *  
 * @version 2008/06/12
 * @author  masahito suzuki
 * @since   Rawio 1.00
 */
public interface Baseio {
    
    /**
     * I/Oモード : 基本.
     */
    public static final int IO_TYPE_BASE = 0 ;
    
    /**
     * I/Oモード : 非同期.
     */
    public static final int IO_TYPE_ASYNC = 1 ;
    
    /**
     * I/Oモード : Mapping.
     */
    public static final int IO_TYPE_MAPPING = 2 ;
    
    /**
     * データの更新.
     * @exception Exception 例外.
     */
    public void flush() throws Exception ;
    
    /**
     * 容量を増やす.
     * @param size 追加する容量を設定します.
     * @exception Exception 例外.
     */
    public void expansion( int size ) throws Exception ;
    
    /**
     * セクタサイズを取得.
     * @return int セクタサイズが返されます.
     */
    public int getSector() ;
    
    /**
     * オープンファイル名を取得.
     * @return String オープンファイル名が返されます.
     */
    public String getName() ;
    
    /**
     * ファイルサイズを取得.
     * @return int ファイルサイズが返されます.<BR>
     *             単位は、セクタです.
     */
    public int length() ;
    
    /**
     * ファイルを読み込む.
     * @param no 読み込み項番を設定します.
     * @return byte[] 読み込まれた内容が返されます.
     * @exception Exception 例外.
     */
    public byte[] read( int no ) throws Exception ;
    
    /**
     * ファイルを読み込む.
     * @param out 読み込まれたバイナリが返されます.
     * @param no 読み込み項番を設定します.
     * @exception Exception 例外.
     */
    public void read( byte[] out,int no ) throws Exception ;
    
    /**
     * ファイルの書込み.
     * @param in 書込み対象のバイナリを設定します.
     * @param no 書込み項番を設定します.
     * @exception Exception 例外.
     */
    public void write( byte[] in,int no ) throws Exception ;
    
    /**
     * ファイルの書込み.
     * @param mode [true]の場合、書込みバイナリをそのまま利用して処理します.<BR>
     *             ただし、この場合は、書込みバイナリ長はセクタ数と同一でないといけません.
     * @param in 書込み対象のバイナリを設定します.
     * @param no 書込み項番を設定します.
     * @exception Exception 例外.
     */
    public void write( boolean mode,byte[] in,int no ) throws Exception ;
    
    /**
     * オブジェクトタイプを取得.
     * @return int オブジェクトタイプが返されます.
     */
    public int getType() ;
    
}
