package org.maachang.rawio.mapping ;

import org.maachang.rawio.Baseio;

/**
 * MappingI/Oインスタンス生成オブジェクト.
 *  
 * @version 2008/06/12
 * @author  masahito suzuki
 * @since   Rawio 1.00
 */
public class MappingioInstance {
    private MappingioInstance() {}
    
    /**
     * MappingI/Oオブジェクトを生成.
     * @param io Baseioオブジェクトを設定します.
     * @return Mappingio Mapping可能オブジェクトが返されます.
     * @exception Exception 例外.
     */
    public static final Mappingio getInstance( Baseio io ) throws Exception {
        if( io == null ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        if( io.getType() == Baseio.IO_TYPE_MAPPING ) {
            throw new IllegalArgumentException( "指定オブジェクトはMappingオブジェクトです" ) ;
        }
        return new MappingioImpl( io ) ;
    }
    
}
