/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.common.POIFSConstants;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.poifs.storage.HeaderBlockConstants;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.IntegerField;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LongField;

public class HeaderBlockReader
implements HeaderBlockConstants {
    private int bigBlockSize = 512;
    private IntegerField _bat_count;
    private IntegerField _property_start;
    private IntegerField _sbat_start;
    private IntegerField _xbat_start;
    private IntegerField _xbat_count;
    private byte[] _data;

    public HeaderBlockReader(InputStream stream) throws IOException {
        LongField signature;
        byte[] blockStart = new byte[32];
        int bsCount = IOUtils.readFully(stream, blockStart);
        if (bsCount != 32) {
            this.alertShortRead(bsCount);
        }
        if (blockStart[30] == 12) {
            this.bigBlockSize = 4096;
        }
        this._data = new byte[this.bigBlockSize];
        System.arraycopy(blockStart, 0, this._data, 0, blockStart.length);
        int byte_count = IOUtils.readFully(stream, this._data, blockStart.length, this._data.length - blockStart.length);
        if (byte_count + bsCount != this.bigBlockSize) {
            this.alertShortRead(byte_count);
        }
        if ((signature = new LongField(0, this._data)).get() != -2226271756974174256L) {
            byte[] OOXML_FILE_HEADER = POIFSConstants.OOXML_FILE_HEADER;
            if (this._data[0] == OOXML_FILE_HEADER[0] && this._data[1] == OOXML_FILE_HEADER[1] && this._data[2] == OOXML_FILE_HEADER[2] && this._data[3] == OOXML_FILE_HEADER[3]) {
                throw new OfficeXmlFileException("The supplied data appears to be in the Office 2007+ XML. POI only supports OLE2 Office documents");
            }
            throw new IOException("Invalid header signature; read " + signature.get() + ", expected " + -2226271756974174256L);
        }
        this._bat_count = new IntegerField(44, this._data);
        this._property_start = new IntegerField(48, this._data);
        this._sbat_start = new IntegerField(60, this._data);
        this._xbat_start = new IntegerField(68, this._data);
        this._xbat_count = new IntegerField(72, this._data);
    }

    private void alertShortRead(int read) throws IOException {
        if (read == -1) {
            read = 0;
        }
        String type = " byte" + (read == 1 ? "" : "s");
        throw new IOException("Unable to read entire header; " + read + type + " read; expected " + this.bigBlockSize + " bytes");
    }

    public int getPropertyStart() {
        return this._property_start.get();
    }

    public int getSBATStart() {
        return this._sbat_start.get();
    }

    public int getBATCount() {
        return this._bat_count.get();
    }

    public int[] getBATArray() {
        int[] result = new int[109];
        int offset = 76;
        for (int j = 0; j < 109; ++j) {
            result[j] = LittleEndian.getInt(this._data, offset);
            offset += 4;
        }
        return result;
    }

    public int getXBATCount() {
        return this._xbat_count.get();
    }

    public int getXBATIndex() {
        return this._xbat_start.get();
    }

    public int getBigBlockSize() {
        return this.bigBlockSize;
    }
}

