/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.dsn;

import com.sun.mail.dsn.DeliveryStatus;
import com.sun.mail.dsn.MessageHeaders;
import java.io.IOException;
import java.util.Vector;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MultipartReport
extends MimeMultipart {
    protected boolean constructed;

    public MultipartReport() throws MessagingException {
        super("report");
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        this.setBodyPart((BodyPart)mimeBodyPart, 0);
        mimeBodyPart = new MimeBodyPart();
        this.setBodyPart((BodyPart)mimeBodyPart, 1);
        this.constructed = true;
    }

    public MultipartReport(String string, DeliveryStatus deliveryStatus) throws MessagingException {
        super("report");
        ContentType contentType = new ContentType(this.contentType);
        contentType.setParameter("report-type", "delivery-status");
        this.contentType = contentType.toString();
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setText(string);
        this.setBodyPart((BodyPart)mimeBodyPart, 0);
        mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent((Object)deliveryStatus, "message/delivery-status");
        this.setBodyPart((BodyPart)mimeBodyPart, 1);
        this.constructed = true;
    }

    public MultipartReport(String string, DeliveryStatus deliveryStatus, MimeMessage mimeMessage) throws MessagingException {
        this(string, deliveryStatus);
        if (mimeMessage != null) {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setContent((Object)mimeMessage, "message/rfc822");
            this.setBodyPart((BodyPart)mimeBodyPart, 2);
        }
    }

    public MultipartReport(String string, DeliveryStatus deliveryStatus, InternetHeaders internetHeaders) throws MessagingException {
        this(string, deliveryStatus);
        if (internetHeaders != null) {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setContent((Object)new MessageHeaders(internetHeaders), "text/rfc822-headers");
            this.setBodyPart((BodyPart)mimeBodyPart, 2);
        }
    }

    public MultipartReport(DataSource dataSource) throws MessagingException {
        super(dataSource);
        this.parse();
        this.constructed = true;
    }

    public synchronized String getText() throws MessagingException {
        try {
            BodyPart bodyPart = this.getBodyPart(0);
            if (bodyPart.isMimeType("text/plain")) {
                return (String)bodyPart.getContent();
            }
            if (bodyPart.isMimeType("multipart/alternative")) {
                Multipart multipart = (Multipart)bodyPart.getContent();
                int n = 0;
                while (n < multipart.getCount()) {
                    bodyPart = multipart.getBodyPart(n);
                    if (bodyPart.isMimeType("text/plain")) {
                        return (String)bodyPart.getContent();
                    }
                    ++n;
                }
            }
        }
        catch (IOException iOException) {
            throw new MessagingException("Exception getting text content", (Exception)iOException);
        }
        return null;
    }

    public synchronized void setText(String string) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setText(string);
        this.setBodyPart((BodyPart)mimeBodyPart, 0);
    }

    public synchronized MimeBodyPart getTextBodyPart() throws MessagingException {
        return (MimeBodyPart)this.getBodyPart(0);
    }

    public synchronized void setTextBodyPart(MimeBodyPart mimeBodyPart) throws MessagingException {
        this.setBodyPart((BodyPart)mimeBodyPart, 0);
    }

    public synchronized DeliveryStatus getDeliveryStatus() throws MessagingException {
        if (this.getCount() < 2) {
            return null;
        }
        BodyPart bodyPart = this.getBodyPart(1);
        if (!bodyPart.isMimeType("message/delivery-status")) {
            return null;
        }
        try {
            return (DeliveryStatus)bodyPart.getContent();
        }
        catch (IOException iOException) {
            throw new MessagingException("IOException getting DeliveryStatus", (Exception)iOException);
        }
    }

    public synchronized void setDeliveryStatus(DeliveryStatus deliveryStatus) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent((Object)deliveryStatus, "message/delivery-status");
        this.setBodyPart((BodyPart)mimeBodyPart, 2);
        ContentType contentType = new ContentType(this.contentType);
        contentType.setParameter("report-type", "delivery-status");
        this.contentType = contentType.toString();
    }

    public synchronized MimeMessage getReturnedMessage() throws MessagingException {
        if (this.getCount() < 3) {
            return null;
        }
        BodyPart bodyPart = this.getBodyPart(2);
        if (!bodyPart.isMimeType("message/rfc822") && !bodyPart.isMimeType("text/rfc822-headers")) {
            return null;
        }
        try {
            return (MimeMessage)bodyPart.getContent();
        }
        catch (IOException iOException) {
            throw new MessagingException("IOException getting ReturnedMessage", (Exception)iOException);
        }
    }

    public synchronized void setReturnedMessage(MimeMessage mimeMessage) throws MessagingException {
        if (mimeMessage == null) {
            BodyPart bodyPart = (BodyPart)this.parts.elementAt(2);
            super.removeBodyPart(2);
            return;
        }
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        if (mimeMessage instanceof MessageHeaders) {
            mimeBodyPart.setContent((Object)mimeMessage, "text/rfc822-headers");
        } else {
            mimeBodyPart.setContent((Object)mimeMessage, "message/rfc822");
        }
        this.setBodyPart((BodyPart)mimeBodyPart, 2);
    }

    private synchronized void setBodyPart(BodyPart bodyPart, int n) throws MessagingException {
        if (this.parts == null) {
            this.parts = new Vector();
        }
        super.removeBodyPart(n);
        super.addBodyPart(bodyPart, n);
    }

    public synchronized void setSubType(String string) throws MessagingException {
        throw new MessagingException("Can't change subtype of MultipartReport");
    }

    public boolean removeBodyPart(BodyPart bodyPart) throws MessagingException {
        throw new MessagingException("Can't remove body parts from multipart/report");
    }

    public void removeBodyPart(int n) throws MessagingException {
        throw new MessagingException("Can't remove body parts from multipart/report");
    }

    public synchronized void addBodyPart(BodyPart bodyPart) throws MessagingException {
        if (this.constructed) {
            throw new MessagingException("Can't add body parts to multipart/report 1");
        }
        super.addBodyPart(bodyPart);
    }

    public synchronized void addBodyPart(BodyPart bodyPart, int n) throws MessagingException {
        throw new MessagingException("Can't add body parts to multipart/report 2");
    }
}

