/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.session.client.local;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.maachang.session.client.PSession;
import org.maachang.session.engine.PersistenceEngine;
import org.maachang.util.ArrayBinary;
import org.maachang.util.SerializableUtil;

class PSessionLocalImpl
implements PSession {
    private static final int VALUE_TYPE_STRING = 1;
    private static final int VALUE_TYPE_BINARY = 2;
    private static final int VALUE_TYPE_OBJECT = 3;
    private String sessionId = null;
    private PersistenceEngine engine = null;

    private PSessionLocalImpl() {
    }

    public PSessionLocalImpl(String sessionId, PersistenceEngine engine) throws Exception {
        if (sessionId == null || (sessionId = sessionId.trim()).length() != 48 || engine == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.sessionId = sessionId;
        this.engine = engine;
    }

    public void put(String key, Object value) throws Exception {
        if (key == null || (key = key.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305f\u8981\u7d20\u30ad\u30fc\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (value == null) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305f\u8981\u7d20\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (value instanceof String && ((String)value).length() <= 0) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305f\u8981\u7d20\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (value instanceof byte[] && ((byte[])value).length <= 0) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305f\u8981\u7d20\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!(value instanceof Serializable) || value instanceof Map || value instanceof List) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305f\u8981\u7d20\u306f\u30b7\u30ea\u30a2\u30e9\u30a4\u30ba\u53ef\u80fd\u306a\u5f62\u5f0f\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
        }
        ArrayBinary b = new ArrayBinary();
        byte[] valBin = null;
        if (value instanceof String) {
            valBin = ((String)value).getBytes("UTF8");
            b.write(new byte[]{1});
            b.write(valBin);
        } else if (value instanceof byte[]) {
            b.write(new byte[]{2});
            b.write((byte[])value);
        } else {
            valBin = SerializableUtil.toBinary((Serializable)((Serializable)value));
            b.write(new byte[]{3});
            b.write(valBin);
        }
        this.engine.put(this.sessionId, key, b.getBinary());
    }

    public void remove(String key) throws Exception {
        if (key == null || (key = key.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305f\u8981\u7d20\u30ad\u30fc\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.engine.remove(this.sessionId, key);
    }

    public Object get(String key) throws Exception {
        if (key == null || (key = key.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305f\u8981\u7d20\u30ad\u30fc\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] bin = this.engine.get(this.sessionId, key);
        if (bin == null) {
            return null;
        }
        Object ret = null;
        int type = bin[0] & 0xFF;
        int len = bin.length - 1;
        byte[] b = new byte[len];
        System.arraycopy(bin, 1, b, 0, len);
        bin = null;
        if (type == 1) {
            ret = new String(b, "UTF8");
        } else if (type == 2) {
            ret = b;
        } else if (type == 3) {
            ret = SerializableUtil.toObject((byte[])b);
        }
        return ret;
    }

    public String getSessionId() throws Exception {
        return this.sessionId;
    }

    public long getUpdateTime() throws Exception {
        return this.engine.getLastUpdateTime(this.sessionId);
    }
}

