/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.session.engine;

import org.maachang.session.engine.CacheChild;
import org.maachang.util.atomic.AtomicLONG;
import org.maachang.util.atomic.ReadAtomicList;

class CacheValue {
    private final AtomicLONG lastMod = new AtomicLONG(-1L);
    private final ReadAtomicList values = new ReadAtomicList();

    protected CacheValue() {
        this.lastMod.set(System.currentTimeMillis());
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        this.lastMod.set(-1L);
        this.values.clear();
    }

    protected int search(String key) {
        int len = this.values.size();
        int i = 0;
        while (i < len) {
            CacheChild ch = (CacheChild)this.values.get(i);
            if (ch != null && key.equals(ch.getKey())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private long getLastMod() {
        return this.lastMod.get();
    }

    private void updateLastMod() {
        this.lastMod.set(System.currentTimeMillis());
    }

    public void put(String key, byte[] value) {
        if (key == null || (key = key.trim()).length() <= 0 || value == null || value.length <= 0) {
            return;
        }
        int n = this.search(key);
        if (n <= -1) {
            CacheChild ch = new CacheChild(key, value);
            this.values.add((Object)ch);
        } else {
            ((CacheChild)this.values.get(n)).setValue(value);
        }
        this.updateLastMod();
    }

    public void remove(String key) {
        if (key == null || (key = key.trim()).length() <= 0) {
            return;
        }
        int n = this.search(key);
        if (n >= 0) {
            this.values.remove(n);
        }
        this.updateLastMod();
    }

    protected void remove(int no) {
        if (no <= -1 || no >= this.values.size()) {
            return;
        }
        this.values.remove(no);
        this.updateLastMod();
    }

    public byte[] get(String key) {
        if (key == null || (key = key.trim()).length() <= 0) {
            return null;
        }
        byte[] ret = null;
        int n = this.search(key);
        if (n >= 0) {
            ret = ((CacheChild)this.values.get(n)).getValue();
        }
        this.updateLastMod();
        return ret;
    }

    protected byte[] get(int no) {
        if (no <= -1 || no >= this.values.size()) {
            return null;
        }
        byte[] ret = null;
        CacheChild ch = (CacheChild)this.values.get(no);
        if (ch != null) {
            ret = ch.getValue();
        }
        this.updateLastMod();
        return ret;
    }

    public boolean containsKey(String key) {
        if (key == null || (key = key.trim()).length() <= 0) {
            return false;
        }
        return this.search(key) >= 0;
    }

    public int size() {
        return this.values.size();
    }

    public long getLastTime() {
        return this.getLastMod();
    }
}

