/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.session.engine;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.maachang.session.engine.CreateSessionMonThread;
import org.maachang.session.engine.SessionCache;
import org.maachang.util.BaseRandom;
import org.maachang.util.RandomId;

class CreateSession {
    private static final long TIMEOUT = 30000L;
    private Map<String, Long> map = null;
    private SessionCache cacheSession = null;
    private CreateSessionMonThread thread = null;
    private RandomId ssKey = null;

    private CreateSession() {
    }

    protected CreateSession(SessionCache cacheSession) throws Exception {
        if (cacheSession == null || !cacheSession.isUse()) {
            throw new IllegalArgumentException("SessionCache\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            this.ssKey = new RandomId(48);
            this.cacheSession = cacheSession;
            this.map = new ConcurrentHashMap<String, Long>();
            this.thread = new CreateSessionMonThread(this.map, 30000L);
        }
        catch (Exception e) {
            this.destroy();
            throw e;
        }
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.thread != null) {
            this.thread.stopThread();
        }
        this.thread = null;
        if (this.map != null) {
            this.map.clear();
        }
        this.map = null;
        this.cacheSession = null;
        this.ssKey = null;
    }

    public String createSessionKey(BaseRandom random) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u7121\u52b9\u306a\u72b6\u614b\u3067\u3059");
        }
        String ret = null;
        RandomId randKey = this.ssKey;
        while (this.map.containsKey(ret = randKey.get(random)) || this.cacheSession.containsKey(ret)) {
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
        this.map.put(ret, new Long(System.currentTimeMillis()));
        return ret;
    }

    public boolean containsKey(String sessionId) {
        if (sessionId == null || (sessionId = sessionId.trim()).length() != 48) {
            return false;
        }
        if (this.map.containsKey(sessionId)) {
            this.map.put(sessionId, new Long(System.currentTimeMillis()));
            return true;
        }
        return false;
    }

    public boolean isUse() {
        return this.map != null && this.cacheSession != null && this.thread != null;
    }
}

