/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.session.engine;

import java.util.ArrayList;
import org.maachang.util.ConvertParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SessionChild {
    private long lastMod = -1L;
    private ArrayList<byte[]> child = null;

    public SessionChild() {
        this.lastMod = System.currentTimeMillis();
        this.child = new ArrayList();
    }

    public SessionChild(byte[] bin) throws Exception {
        int p = 0;
        long time = ConvertParam.convertLong((int)p, (byte[])bin);
        int len = ConvertParam.convertInt((int)(p += 8), (byte[])bin);
        p += 4;
        ArrayList<byte[]> lst = new ArrayList<byte[]>();
        int i = 0;
        while (i < len) {
            int strLen = ConvertParam.convertInt((int)p, (byte[])bin);
            p += 4;
            if (strLen > 0) {
                byte[] b = new byte[strLen];
                System.arraycopy(bin, p, b, 0, strLen);
                p += strLen;
                lst.add(b);
            }
            ++i;
        }
        this.lastMod = time;
        this.child = lst;
    }

    protected void finalize() {
        this.destroy();
    }

    public void destroy() {
        this.lastMod = -1L;
        this.child = null;
    }

    public long lastMod() {
        return this.lastMod;
    }

    public void update() {
        this.lastMod = System.currentTimeMillis();
    }

    public boolean containsKey(String key) {
        try {
            return this.containsKey(key.getBytes("UTF8"));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean containsKey(byte[] key) {
        return this.search(key) >= 0;
    }

    public int search(String key) {
        try {
            return this.search(key.getBytes("UTF8"));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int search(byte[] key) {
        int klen = key.length;
        int len = this.child.size();
        int i = 0;
        while (i < len) {
            byte[] x = this.child.get(i);
            if (x.length == klen) {
                boolean flg = true;
                int j = 0;
                while (j < klen) {
                    if (x[j] != key[j]) {
                        flg = false;
                        break;
                    }
                    ++j;
                }
                if (flg) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public ArrayList<byte[]> getChild() {
        return this.child;
    }

    public byte[] toBinary() throws Exception {
        int len = this.child.size();
        int max = 12;
        int i = 0;
        while (i < len) {
            byte[] b = this.child.get(i);
            max += 4 + b.length;
            ++i;
        }
        byte[] ret = new byte[max];
        int p = 0;
        ConvertParam.convertLong((byte[])ret, (int)p, (long)this.lastMod);
        ConvertParam.convertInt((byte[])ret, (int)(p += 8), (int)len);
        p += 4;
        int i2 = 0;
        while (i2 < len) {
            byte[] b = this.child.get(i2);
            int strLen = b.length;
            ConvertParam.convertInt((byte[])ret, (int)p, (int)strLen);
            System.arraycopy(b, 0, ret, p += 4, strLen);
            p += strLen;
            ++i2;
        }
        return ret;
    }
}

