/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao;

import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import org.maachang.dao.ExecutionDao;
import org.maachang.dao.dbms.MetaColumn;
import org.maachang.dao.dbms.MetaFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultLine {
    protected ResultSet result = null;
    protected String name = null;
    protected int count = -1;
    protected MetaColumn column = null;

    protected void finalize() throws Exception {
        this.clear();
    }

    public void create(String name, ResultSet result, MetaColumn column) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0 || result == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.clear();
        this.result = result;
        this.name = name;
        this.column = column;
    }

    public void clear() {
        if (this.result != null) {
            try {
                this.result.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.result = null;
        this.name = null;
        this.column = null;
        this.count = -1;
    }

    public Map<String, Object> next() throws Exception {
        if (this.result == null) {
            return null;
        }
        if (!this.result.next()) {
            return null;
        }
        if (this.column == null) {
            this.column = MetaFactory.getInstance().getMetaColumn(true, this.name);
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ExecutionDao.convertResultByObject(ret, this.column, this.result, this.column.size());
        ++this.count;
        return ret;
    }

    public int count() {
        return this.count;
    }

    public String getModelName() {
        return this.name;
    }

    public boolean isUse() {
        return this.result != null;
    }
}

