/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.dao.dbms.MetaColumn;
import org.maachang.dao.dbms.MetaFactory;
import org.maachang.dao.dbms.Record;
import org.maachang.dao.dbms.kind.SupportKind;

public class BaseRecord
implements Record {
    private static final Log LOG = LogFactory.getLog(BaseRecord.class);
    private SupportKind kind = null;
    private boolean supportBoolean = false;
    private Connection connection = null;
    private boolean commitRollbackFlag = true;
    private boolean sequence = false;
    private Statement statement = null;
    private boolean debug = false;

    private BaseRecord() {
    }

    public BaseRecord(SupportKind kind, boolean debug, Connection connection) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        this.kind = kind;
        this.debug = debug;
        this.supportBoolean = kind.isBoolean();
        this.sequence = kind.getSequenceId(null) != null;
        this.connection = connection;
    }

    protected void finalize() throws Exception {
        this.close();
    }

    public void close() {
        if (!this.commitRollbackFlag && this.connection != null) {
            try {
                this.connection.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.clearStatements();
        this.commitRollbackFlag = true;
        this.connection = null;
        this.statement = null;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean commit() throws Exception {
        if (this.connection != null) {
            if (this.debug && LOG.isDebugEnabled()) {
                LOG.debug((Object)"# sql:commit");
            }
            if (!this.commitRollbackFlag) {
                this.connection.commit();
                this.commitRollbackFlag = true;
                this.clearStatements();
                return true;
            }
            this.connection.rollback();
            this.commitRollbackFlag = true;
            this.clearStatements();
            return false;
        }
        this.clearStatements();
        return false;
    }

    public boolean rollback() throws Exception {
        if (this.connection != null) {
            if (this.debug && LOG.isDebugEnabled()) {
                LOG.debug((Object)"# sql:rollback");
            }
            this.connection.rollback();
            this.commitRollbackFlag = true;
            this.clearStatements();
            return true;
        }
        this.clearStatements();
        return false;
    }

    public synchronized void clearStatements() {
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.statement = null;
        }
    }

    public MetaColumn getMetaColumn(String table) throws Exception {
        return MetaFactory.getInstance().getMetaColumn(table);
    }

    public boolean isUse() {
        boolean ret = false;
        try {
            ret = this.connection != null && !this.connection.isClosed();
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public ResultSet executeQuery(String sql) throws Exception {
        if (this.connection == null) {
            throw new IOException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u60c5\u5831\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (this.debug && LOG.isDebugEnabled()) {
            LOG.debug((Object)("# sql:" + sql));
        }
        long time = System.currentTimeMillis();
        ResultSet ret = this.getStatement().executeQuery(sql);
        if (this.debug && LOG.isDebugEnabled()) {
            LOG.debug((Object)("# sql:" + sql + "[" + (System.currentTimeMillis() - time) + "ms]"));
        }
        this.commitRollbackFlag = false;
        return ret;
    }

    public int executeUpdate(String sql) throws Exception {
        if (this.connection == null) {
            throw new IOException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u60c5\u5831\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (this.debug && LOG.isDebugEnabled()) {
            LOG.debug((Object)("# sql:" + sql));
        }
        long time = System.currentTimeMillis();
        int ret = this.getStatement().executeUpdate(sql);
        if (this.debug && LOG.isDebugEnabled()) {
            LOG.debug((Object)("# sql:" + sql + "[" + (System.currentTimeMillis() - time) + "ms]"));
        }
        this.commitRollbackFlag = false;
        return ret;
    }

    private synchronized Statement getStatement() throws Exception {
        if (this.statement == null) {
            this.statement = this.connection.createStatement();
        }
        return this.statement;
    }

    public ResultSet executeQuery(String sql, Object[] params, int size) throws Exception {
        if (this.connection == null) {
            throw new IOException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u60c5\u5831\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (sql == null || (sql = sql.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.debug && LOG.isDebugEnabled()) {
            LOG.debug((Object)("# sql:" + sql));
        }
        long time = System.currentTimeMillis();
        PreparedStatement pre = this.getPreparedStatement(true, sql);
        BaseRecord.putParams(this.supportBoolean, pre, params, size);
        ResultSet ret = pre.executeQuery();
        this.commitRollbackFlag = false;
        if (this.debug && LOG.isDebugEnabled()) {
            LOG.debug((Object)("# sql:" + sql + "[" + (System.currentTimeMillis() - time) + "ms]"));
        }
        return ret;
    }

    public int executeUpdate(String sql, Object[] params, int size) throws Exception {
        if (this.connection == null) {
            throw new IOException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u60c5\u5831\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (sql == null || (sql = sql.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.debug && LOG.isDebugEnabled()) {
            LOG.debug((Object)("# sql:" + sql));
        }
        long time = System.currentTimeMillis();
        PreparedStatement pre = this.getPreparedStatement(false, sql);
        BaseRecord.putParams(this.supportBoolean, pre, params, size);
        int ret = pre.executeUpdate();
        this.commitRollbackFlag = false;
        if (this.debug && LOG.isDebugEnabled()) {
            LOG.debug((Object)("# sql:" + sql + "[" + (System.currentTimeMillis() - time) + "ms]"));
        }
        return ret;
    }

    private synchronized PreparedStatement getPreparedStatement(boolean readOnly, String sql) throws Exception {
        if (sql == null || (sql = sql.trim()).length() <= 0 || this.connection == null) {
            return null;
        }
        PreparedStatement ret = null;
        ret = readOnly ? this.connection.prepareStatement(sql, 1004, 1007) : this.connection.prepareStatement(sql);
        return ret;
    }

    public SupportKind getSupportKind() {
        return this.kind;
    }

    public boolean isSequence() {
        return this.sequence;
    }

    public boolean isDebug() {
        return this.debug;
    }

    private static final void putParams(boolean supportBoolean, PreparedStatement pre, Object[] params, int size) throws Exception {
        if (params != null && params.length >= size) {
            int i = 0;
            while (i < size) {
                BaseRecord.putOneParam(supportBoolean, i, pre, params[i]);
                ++i;
            }
        }
    }

    private static final void putOneParam(boolean supportBoolean, int no, PreparedStatement pre, Object one) throws Exception {
        if (one == null) {
            pre.setObject(no + 1, null);
        } else if (one instanceof Boolean) {
            boolean b = (Boolean)one;
            if (!supportBoolean) {
                if (b) {
                    pre.setString(no + 1, "1");
                } else {
                    pre.setString(no + 1, "0");
                }
            } else {
                pre.setBoolean(no + 1, b);
            }
        } else if (one instanceof String) {
            pre.setString(no + 1, (String)one);
        } else if (one instanceof Integer) {
            pre.setInt(no + 1, (Integer)one);
        } else if (one instanceof Long) {
            pre.setLong(no + 1, (Long)one);
        } else if (one instanceof Float) {
            pre.setFloat(no + 1, ((Float)one).floatValue());
        } else if (one instanceof Double) {
            pre.setDouble(no + 1, (Double)one);
        } else if (one instanceof java.util.Date) {
            if (one instanceof Timestamp) {
                pre.setTimestamp(no + 1, (Timestamp)one);
            } else if (one instanceof Time) {
                pre.setTime(no + 1, (Time)one);
            } else if (one instanceof Date) {
                pre.setDate(no + 1, (Date)one);
            } else {
                pre.setTimestamp(no + 1, new Timestamp(((java.util.Date)one).getTime()));
            }
        } else if (one instanceof byte[]) {
            pre.setBytes(no + 1, (byte[])one);
        } else {
            throw new IllegalArgumentException("\u6307\u5b9a\u30d1\u30e9\u30e1\u30fc\u30bf[" + (no + 1) + "]\u306e\u6761\u4ef6\u306f\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093:" + one.getClass().getName());
        }
    }
}

