/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms;

import org.maachang.dao.dbms.RecordSequenceMeta;
import org.maachang.util.SerializableSequenceList;

public class RecordSequenceId {
    private static final int DEFAULT_LENGTH = 32;
    private SerializableSequenceList sequence = null;
    private RecordSequenceMeta meta = null;

    private RecordSequenceId() {
    }

    public RecordSequenceId(String fileName, String metaFileName) throws Exception {
        if (fileName == null || fileName.trim().length() <= 0 || metaFileName == null || (metaFileName = metaFileName.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.sequence = new SerializableSequenceList(32, fileName);
        this.meta = new RecordSequenceMeta(metaFileName);
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.sequence != null) {
            this.sequence.destroy();
        }
        if (this.meta != null) {
            this.meta.destroy();
        }
        this.sequence = null;
        this.meta = null;
    }

    public synchronized void clearSequence() throws Exception {
        int len = this.sequence.length();
        int i = 1;
        while (i < len) {
            this.sequence.set(i, 0L);
            ++i;
        }
    }

    public synchronized void allClear() throws Exception {
        int len = this.sequence.length();
        int i = 0;
        while (i < len) {
            this.sequence.set(i, 0L);
            ++i;
        }
    }

    public synchronized boolean isUse() {
        return this.sequence != null && this.sequence.isUse() && this.meta != null && this.meta.isUse();
    }

    private int getNo(String name) throws Exception {
        int ret;
        if (!this.meta.containsKey(name)) {
            int newNo = (int)this.sequence.get(0);
            newNo = newNo <= 0 ? 1 : ++newNo;
            this.sequence.set(0, (long)newNo);
            if (this.sequence.length() <= newNo) {
                this.sequence.addSpace(32);
            }
            this.meta.put(name, newNo);
            ret = newNo;
        } else {
            ret = this.meta.get(name);
        }
        return ret;
    }

    public synchronized void setId(String name, long seq) throws Exception {
        if (seq <= -1L) {
            throw new IllegalArgumentException("\u6307\u5b9a\u30b7\u30fc\u30b1\u30f3\u30b9ID\u306f\u4e0d\u6b63\u3067\u3059:" + seq);
        }
        int no = this.getNo(name);
        long now = this.sequence.get(no);
        if (now < seq) {
            this.sequence.set(no, seq);
        }
    }

    public synchronized long getId(String name) throws Exception {
        int no = this.getNo(name);
        return this.sequence.getId(no);
    }

    public void clearSequence(String name) throws Exception {
        int no = this.getNo(name);
        this.sequence.set(no, 0L);
    }
}

