/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms.pool;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.maachang.dao.dbms.pool.ConnectManager;
import org.maachang.dao.dbms.pool.DbcpPooling;

public class ConnectPoolFactory {
    private final Map<String, DbcpPooling> connectManager = new ConcurrentHashMap<String, DbcpPooling>();
    private static final ConnectPoolFactory SNGL = new ConnectPoolFactory();

    private ConnectPoolFactory() {
    }

    public static final ConnectPoolFactory getInstance() {
        return SNGL;
    }

    public void clear() {
        this.connectManager.clear();
    }

    public void add(String name, String driver, String url, String user, String passwd, long keepAlive, int max, String checkSQL, boolean readOnly, boolean autoCommit) throws Exception {
        if (url == null || (url = url.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u6307\u5b9aurl\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u6307\u5b9a\u540d\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (this.connectManager.get(name) != null) {
            throw new IllegalArgumentException("\u6307\u5b9a\u540d[" + name + "]\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059");
        }
        DbcpPooling obj = new DbcpPooling(driver, url, user, passwd, keepAlive, max, checkSQL, readOnly, autoCommit);
        this.connectManager.put(name, obj);
    }

    public void remove(String name) {
        if (name == null || (name = name.trim()).length() <= 0) {
            return;
        }
        this.connectManager.remove(name);
    }

    public static ConnectManager get(String driver, String url, String user, String passwd, long keepAlive, int max, String checkSQL, boolean readOnly, boolean autoCommit) throws Exception {
        if (url == null || (url = url.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u6307\u5b9aurl\u306f\u4e0d\u6b63\u3067\u3059");
        }
        DbcpPooling obj = new DbcpPooling(driver, url, user, passwd, keepAlive, max, checkSQL, readOnly, autoCommit);
        return new ConnectManager(obj);
    }

    public ConnectManager get(String name) {
        if (name == null || (name = name.trim()).length() <= 0) {
            return null;
        }
        DbcpPooling man = this.connectManager.get(name);
        ConnectManager ret = null;
        if (man != null) {
            try {
                ret = new ConnectManager(man);
            }
            catch (Exception e) {
                ret = null;
            }
        }
        return ret;
    }

    public String[] getNames() {
        String[] ret = null;
        int len = this.connectManager.size();
        if (len > 0) {
            Object[] objs = this.connectManager.keySet().toArray();
            ret = new String[len];
            int i = 0;
            while (i < len) {
                ret[i] = (String)objs[i];
                objs[i] = null;
                ++i;
            }
            Object[] objectArray = null;
        }
        return ret;
    }

    public int size() {
        return this.connectManager.size();
    }
}

