/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.jsr.script.javascript;

import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.maachang.jsr.script.javascript.RhinoScriptEngine;
import org.maachang.jsr.script.util.ExtendedScriptException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

final class RhinoCompiledScript
extends CompiledScript {
    private RhinoScriptEngine engine;
    private Script script;
    private static final boolean DEBUG = false;

    RhinoCompiledScript(RhinoScriptEngine engine, Script script) {
        this.engine = engine;
        this.script = script;
    }

    public Object eval(ScriptContext context) throws ScriptException {
        Object result = null;
        Context cx = RhinoScriptEngine.enterContext();
        try {
            try {
                Scriptable scope = this.engine.getRuntimeScope(context);
                Object ret = this.script.exec(cx, scope);
                result = this.engine.unwrapReturnValue(ret);
            }
            catch (JavaScriptException jse) {
                int line = jse.lineNumber();
                line = line == 0 ? -1 : line;
                Object value = jse.getValue();
                String str = value != null && value.getClass().getName().equals("org.mozilla.javascript.NativeError") ? value.toString() : jse.toString();
                throw new ExtendedScriptException(jse, str, jse.sourceName(), line);
            }
            catch (RhinoException re) {
                int line = re.lineNumber();
                line = line == 0 ? -1 : line;
                throw new ExtendedScriptException(re, re.toString(), re.sourceName(), line);
            }
        }
        finally {
            Context.exit();
        }
        return result;
    }

    public ScriptEngine getEngine() {
        return this.engine;
    }
}

