/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.jsr.script.javascript;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.maachang.jsr.script.api.ApiManager;
import org.maachang.jsr.script.api.ExternalBindings;
import org.maachang.jsr.script.javascript.ExternalScriptable;
import org.maachang.jsr.script.javascript.JSAdapter;
import org.maachang.jsr.script.javascript.RhinoCompiledScript;
import org.maachang.jsr.script.javascript.RhinoScriptEngineFactory;
import org.maachang.jsr.script.javascript.RhinoSimpleScriptContext;
import org.maachang.jsr.script.util.ExtendedScriptException;
import org.maachang.jsr.script.util.InterfaceImplementor;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.LazilyLoadedCtor;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RhinoScriptEngine
implements ScriptEngine,
Invocable,
Compilable {
    private static final int COMP_OPT_LEVEL = 9;
    private static final int EVAL_OPT_LEVEL = 1;
    public static final boolean DEBUG = false;
    private static final String TOPLEVEL_SCRIPT_NAME = "META-INF/toplevel.js";
    private ScriptableObject topLevel = null;
    private RhinoSimpleScriptContext rhinoContext = new RhinoSimpleScriptContext();
    private Map indexedProps;
    private ScriptEngineFactory factory;
    private InterfaceImplementor implementor;
    private static final String[] FUNC_NAMES = new String[]{"globalBindings", "print", "println", "isNull", "objectClassName", "className", "isEmpty", "useString", "isNumeric", "valueof", "convertString", "parseInt", "parseNumber", "_parseValue", "trim", "startsWith", "endsWith", "changeString", "currentTimeMillis"};

    public RhinoScriptEngine() {
        Context cx = RhinoScriptEngine.enterContext();
        try {
            this.topLevel = new ImporterTopLevel(cx, false);
            new LazilyLoadedCtor(this.topLevel, "JSAdapter", "org.maachang.jsr.script.javascript.JSAdapter", false);
            this.topLevel.defineFunctionProperties(FUNC_NAMES, RhinoScriptEngine.class, 2);
            this.processAllTopLevelScripts(cx);
        }
        finally {
            Context.exit();
        }
        this.indexedProps = new HashMap();
        this.implementor = new InterfaceImplementor(this){

            protected Object convertResult(Method method, Object res) throws ScriptException {
                Class<?> desiredType = method.getReturnType();
                if (desiredType == Void.TYPE) {
                    return null;
                }
                return Context.jsToJava((Object)res, desiredType);
            }
        };
    }

    @Override
    public void setContext(ScriptContext ctxt) {
        if (ctxt == null) {
            throw new NullPointerException("null context");
        }
        if (!(ctxt instanceof RhinoSimpleScriptContext)) {
            throw new RuntimeException("RhinoSimpleScriptContext\u4ee5\u5916\u306f\u672a\u30b5\u30dd\u30fc\u30c8!!");
        }
        this.rhinoContext = (RhinoSimpleScriptContext)ctxt;
    }

    @Override
    public ScriptContext getContext() {
        return this.rhinoContext;
    }

    @Override
    public Bindings getBindings(int scope) {
        if (scope == 200) {
            return this.rhinoContext.getBindings(200);
        }
        if (scope == 100) {
            return this.rhinoContext.getBindings(100);
        }
        throw new IllegalArgumentException("Invalid scope value.");
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
    }

    @Override
    public void put(String key, Object value) {
        Bindings nn = this.getBindings(100);
        if (nn != null) {
            nn.put(key, value);
        }
    }

    @Override
    public Object get(String key) {
        Bindings nn = this.getBindings(100);
        if (nn != null) {
            return nn.get(key);
        }
        return null;
    }

    @Override
    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        throw new RuntimeException("bindings\u76f4\u63a5\u6307\u5b9a\u306f\u672a\u30b5\u30dd\u30fc\u30c8!!");
    }

    @Override
    public Object eval(String script, Bindings bindings) throws ScriptException {
        throw new RuntimeException("bindings\u76f4\u63a5\u6307\u5b9a\u306f\u672a\u30b5\u30dd\u30fc\u30c8!!");
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        return this.eval(reader, (ScriptContext)this.rhinoContext);
    }

    @Override
    public Object eval(String script) throws ScriptException {
        return this.eval(script, (ScriptContext)this.rhinoContext);
    }

    @Override
    public Object eval(Reader reader, ScriptContext ctxt) throws ScriptException {
        Object ret;
        if (ctxt != null && !(ctxt instanceof RhinoSimpleScriptContext)) {
            throw new RuntimeException("RhinoSimpleScriptContext\u4ee5\u5916\u306f\u672a\u30b5\u30dd\u30fc\u30c8!!");
        }
        Context cx = RhinoScriptEngine.enterContext();
        try {
            try {
                cx.setOptimizationLevel(1);
                Scriptable scope = this.getRuntimeScope(ctxt);
                scope.put("context", scope, (Object)ctxt);
                String filename = ApiManager.getScriptName();
                filename = filename == null ? "<Unknown source>" : filename;
                ret = cx.evaluateReader(scope, this.preProcessScriptSource(reader), filename, 1, null);
            }
            catch (JavaScriptException jse) {
                int line = jse.lineNumber();
                line = line == 0 ? -1 : line;
                Object value = jse.getValue();
                String str = value != null && value.getClass().getName().equals("org.mozilla.javascript.NativeError") ? value.toString() : jse.toString();
                throw new ExtendedScriptException(jse, str, jse.sourceName(), line);
            }
            catch (RhinoException re) {
                int line = re.lineNumber();
                line = line == 0 ? -1 : line;
                throw new ExtendedScriptException(re, re.toString(), re.sourceName(), line);
            }
            catch (IOException ee) {
                throw new ScriptException(ee);
            }
        }
        finally {
            Context.exit();
        }
        return this.unwrapReturnValue(ret);
    }

    @Override
    public Object eval(String script, ScriptContext ctxt) throws ScriptException {
        if (script == null) {
            throw new NullPointerException("null script");
        }
        if (!(ctxt instanceof RhinoSimpleScriptContext)) {
            throw new RuntimeException("RhinoSimpleScriptContext\u4ee5\u5916\u306f\u672a\u30b5\u30dd\u30fc\u30c8!!");
        }
        return this.eval(this.preProcessScriptSource(new StringReader(script)), ctxt);
    }

    @Override
    public ScriptEngineFactory getFactory() {
        if (this.factory != null) {
            return this.factory;
        }
        return new RhinoScriptEngineFactory();
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return this.invokeMethod(null, name, args);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        Context cx = RhinoScriptEngine.enterContext();
        try {
            cx.setOptimizationLevel(1);
            if (name == null) {
                throw new NullPointerException("method name is null");
            }
            if (thiz != null && !(thiz instanceof Scriptable)) {
                thiz = Context.toObject((Object)thiz, (Scriptable)this.topLevel);
            }
            Scriptable engineScope = this.getRuntimeScope(this.rhinoContext);
            Scriptable localScope = thiz != null ? (Scriptable)thiz : engineScope;
            Object obj = ScriptableObject.getProperty((Scriptable)localScope, (String)name);
            if (!(obj instanceof Function)) {
                throw new NoSuchMethodException("no such method: " + name);
            }
            Function func = (Function)obj;
            Scriptable scope = func.getParentScope();
            if (scope == null) {
                scope = engineScope;
            }
            Object result = func.call(cx, scope, localScope, this.wrapArguments(args));
            Object object = this.unwrapReturnValue(result);
            return object;
        }
        catch (JavaScriptException jse) {
            int line = jse.lineNumber();
            line = line == 0 ? -1 : line;
            Object value = jse.getValue();
            String str = value != null && value.getClass().getName().equals("org.mozilla.javascript.NativeError") ? value.toString() : jse.toString();
            throw new ExtendedScriptException(jse, str, jse.sourceName(), line);
            catch (RhinoException re) {
                line = re.lineNumber();
                line = line == 0 ? -1 : line;
                throw new ExtendedScriptException(re, re.toString(), re.sourceName(), line);
            }
        }
        finally {
            Context.exit();
        }
    }

    @Override
    public <T> T getInterface(Class<T> clasz) {
        try {
            return this.implementor.getInterface(null, clasz);
        }
        catch (ScriptException e) {
            return null;
        }
    }

    @Override
    public <T> T getInterface(Object thiz, Class<T> clasz) {
        if (thiz == null) {
            throw new IllegalArgumentException("script object can not be null");
        }
        try {
            return this.implementor.getInterface(thiz, clasz);
        }
        catch (ScriptException e) {
            return null;
        }
    }

    Scriptable getRuntimeScope(ScriptContext ctxt) {
        if (ctxt == null) {
            throw new NullPointerException("script context can not be null");
        }
        ExternalScriptable newScope = new ExternalScriptable(ctxt, this.indexedProps);
        newScope.setPrototype((Scriptable)this.topLevel);
        newScope.put("context", newScope, ctxt);
        return newScope;
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return this.compile(this.preProcessScriptSource(new StringReader(script)));
    }

    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        RhinoCompiledScript ret = null;
        Context cx = RhinoScriptEngine.enterContext();
        try {
            try {
                cx.setOptimizationLevel(9);
                String filename = ApiManager.getScriptName();
                if (filename == null) {
                    filename = "<Unknown Source>";
                }
                Scriptable scope = this.getRuntimeScope(this.rhinoContext);
                Script scr = cx.compileReader(scope, this.preProcessScriptSource(script), filename, 1, null);
                ret = new RhinoCompiledScript(this, scr);
            }
            catch (Exception e) {
                throw new ScriptException(e);
            }
        }
        finally {
            Context.exit();
        }
        return ret;
    }

    static Context enterContext() {
        return Context.enter();
    }

    void setEngineFactory(ScriptEngineFactory fac) {
        this.factory = fac;
    }

    Object[] wrapArguments(Object[] args) {
        if (args == null) {
            return Context.emptyArgs;
        }
        Object[] res = new Object[args.length];
        int i = 0;
        while (i < res.length) {
            res[i] = Context.javaToJS((Object)args[i], (Scriptable)this.topLevel);
            ++i;
        }
        return res;
    }

    Object unwrapReturnValue(Object result) {
        if (result instanceof Wrapper) {
            result = ((Wrapper)result).unwrap();
        }
        return result instanceof Undefined ? null : result;
    }

    @Override
    public Bindings createBindings() {
        return ExternalBindings.getInstance();
    }

    public static final Object jsToJava(Object jsObj) {
        if (jsObj instanceof Wrapper) {
            Wrapper njb = (Wrapper)jsObj;
            if (njb instanceof NativeJavaClass) {
                return njb;
            }
            Object obj = njb.unwrap();
            if (obj instanceof Number || obj instanceof String || obj instanceof Boolean || obj instanceof Character) {
                return njb;
            }
            return obj;
        }
        return jsObj;
    }

    protected Reader preProcessScriptSource(Reader reader) throws ScriptException {
        return reader;
    }

    protected void processAllTopLevelScripts(Context cx) {
        this.processTopLevelScript(TOPLEVEL_SCRIPT_NAME, cx);
    }

    protected void processTopLevelScript(String scriptName, Context cx) {
        InputStream toplevelScript = this.getClass().getClassLoader().getResourceAsStream(scriptName);
        if (toplevelScript != null) {
            InputStreamReader reader = new InputStreamReader(toplevelScript);
            try {
                try {
                    cx.evaluateReader((Scriptable)this.topLevel, (Reader)reader, scriptName, 1, null);
                }
                catch (Exception exception) {}
            }
            finally {
                try {
                    toplevelScript.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static final Object nativeTo(Object o) {
        if (o == null || o == Undefined.instance) {
            return o;
        }
        if (o instanceof Wrapper) {
            o = ((Wrapper)o).unwrap();
        }
        return o;
    }

    public static final Object globalBindings(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length == 1) {
            Object arg = args[0];
            if (arg instanceof Wrapper) {
                arg = ((Wrapper)arg).unwrap();
            }
            if (arg instanceof ExternalScriptable) {
                ScriptContext ctx = ((ExternalScriptable)arg).getContext();
                Bindings bind = ctx.getBindings(100);
                return Context.javaToJS((Object)bind, (Scriptable)ScriptableObject.getTopLevelScope((Scriptable)thisObj));
            }
        }
        return Context.getUndefinedValue();
    }

    public static final Object print(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length < 1) {
            return null;
        }
        System.out.print(RhinoScriptEngine._convertString(RhinoScriptEngine.nativeTo(args[0])));
        return null;
    }

    public static final Object println(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length < 1) {
            System.out.println();
        } else {
            System.out.println(RhinoScriptEngine._convertString(RhinoScriptEngine.nativeTo(args[0])));
        }
        return null;
    }

    public static final Object rhinoContext(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        return cx;
    }

    public static final Object isNull(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length < 1) {
            return Boolean.FALSE;
        }
        Object o = RhinoScriptEngine.nativeTo(args[0]);
        if (o == null || o == Undefined.instance) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static final Object objectClassName(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length < 1) {
            return null;
        }
        Object o = RhinoScriptEngine.nativeTo(args[0]);
        if (o == null || o == Undefined.instance) {
            return null;
        }
        return o.getClass().getName();
    }

    public static final Object className(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length < 1) {
            return null;
        }
        Object o = RhinoScriptEngine.nativeTo(args[0]);
        if (o == null || o == Undefined.instance) {
            return null;
        }
        return RhinoScriptEngine.className(o);
    }

    public static final Object isEmpty(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length < 1) {
            return Boolean.TRUE;
        }
        Object o = RhinoScriptEngine.nativeTo(args[0]);
        if (o == null || o == Undefined.instance) {
            return Boolean.TRUE;
        }
        String s = RhinoScriptEngine.className(o);
        if ("JSAdapter".equals(s)) {
            JSAdapter js = (JSAdapter)o;
            if (!js.has("empty", thisObj)) {
                return Boolean.TRUE;
            }
            o = js.get("empty", thisObj);
            if (o == null) {
                return Boolean.TRUE;
            }
            if (!((o = RhinoScriptEngine.nativeTo(o)) instanceof Boolean)) {
                return Boolean.TRUE;
            }
            return o;
        }
        if ("NativeObject".equals(s)) {
            Object[] lst = ((Scriptable)o).getIds();
            if (lst != null && lst.length > 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if ("NativeArray".equals(s)) {
            if ((o = ((Scriptable)o).get("length", thisObj)) == null) {
                return Boolean.TRUE;
            }
            if ((o = RhinoScriptEngine.nativeTo(o)) instanceof Double && ((Double)o).intValue() > 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if ("String".equals(s)) {
            return "".equals(o) ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("NativeString".equals(s)) {
            return "".equals(o.toString()) ? Boolean.TRUE : Boolean.FALSE;
        }
        if (o instanceof byte[]) {
            return ((byte[])o).length <= 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (o instanceof Map) {
            return ((Map)o).size() <= 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (o instanceof List) {
            return ((List)o).size() <= 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public static final Object useString(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length < 1) {
            return Boolean.FALSE;
        }
        Object o = RhinoScriptEngine.nativeTo(args[0]);
        if (o == null || o == Undefined.instance) {
            return Boolean.FALSE;
        }
        String s = RhinoScriptEngine.className(o);
        if ("NativeBoolean".equals(s) || "Boolean".equals(s) || "Double".equals(s) || "Float".equals(s) || "Integer".equals(s) || "Long".equals(s) || "Short".equals(s) || "NativeString".equals(s) && RhinoScriptEngine.isUseString(o.toString()) || "String".equals(s) && RhinoScriptEngine.isUseString((String)o)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static final Object isNumeric(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length < 1) {
            return Boolean.FALSE;
        }
        Object o = RhinoScriptEngine.nativeTo(args[0]);
        if (o == null || o == Undefined.instance) {
            return Boolean.FALSE;
        }
        return RhinoScriptEngine.isNumber(null, o) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static final Object typeof(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length < 1) {
            return "undefined";
        }
        return RhinoScriptEngine.objectType(RhinoScriptEngine.nativeTo(args[0]), thisObj);
    }

    public static final Object valueof(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length < 1) {
            return "undefined";
        }
        return RhinoScriptEngine.objectType(RhinoScriptEngine.nativeTo(args[0]), thisObj);
    }

    public static final Object convertString(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length < 1) {
            return "";
        }
        String o = RhinoScriptEngine._convertString(RhinoScriptEngine.nativeTo(args[0]));
        if (o == null) {
            return "";
        }
        return o;
    }

    public static final Object parseInt(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length < 1) {
            return Undefined.instance;
        }
        Object o = RhinoScriptEngine.nativeTo(args[0]);
        if (o == null) {
            return null;
        }
        if (o == Undefined.instance) {
            return Undefined.instance;
        }
        return RhinoScriptEngine._convertInt(o);
    }

    public static final Object parseNumber(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length < 1) {
            return Undefined.instance;
        }
        Object o = RhinoScriptEngine.nativeTo(args[0]);
        if (o == null) {
            return null;
        }
        if (o == Undefined.instance) {
            return Undefined.instance;
        }
        int[] dot = new int[1];
        if (RhinoScriptEngine.isNumber(dot, o)) {
            if (dot[0] == 0) {
                if (!(o instanceof Long)) {
                    o = new Long(o.toString());
                }
                return o;
            }
            if (dot[0] == 1) {
                return RhinoScriptEngine._convertNumber((Double)o);
            }
            if (dot[0] == 2) {
                return RhinoScriptEngine._convertNumber((Float)o);
            }
            if (dot[0] == 3) {
                return new Long(o.toString());
            }
            if (dot[0] == 4) {
                return RhinoScriptEngine._convertNumber(new Double(o.toString()));
            }
        }
        return "NaN";
    }

    public static final Object _parseValue(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length < 1) {
            return "";
        }
        Object o = RhinoScriptEngine.nativeTo(args[0]);
        if (o == null || o == Undefined.instance) {
            return "";
        }
        int[] dot = new int[1];
        if (RhinoScriptEngine.isNumber(dot, o)) {
            if (dot[0] == 0) {
                if (!(o instanceof Long)) {
                    o = new Long(o.toString());
                }
                return o;
            }
            if (dot[0] == 1) {
                return RhinoScriptEngine._convertNumber((Double)o);
            }
            if (dot[0] == 2) {
                return RhinoScriptEngine._convertNumber((Float)o);
            }
            if (dot[0] == 3) {
                String s = o.toString();
                if (s.length() > 1 && s.charAt(0) == '0') {
                    return Context.toString((Object)s);
                }
                return new Long(o.toString());
            }
            if (dot[0] == 4) {
                return RhinoScriptEngine._convertNumber(new Double(o.toString()));
            }
        }
        dot = null;
        String value = null;
        String s = RhinoScriptEngine.className(o);
        if ("String".equals(s)) {
            value = (String)o;
        } else if ("NativeString".equals(s)) {
            value = o.toString();
        } else {
            return args[0];
        }
        s = null;
        String x = value.toLowerCase();
        if ("true".equals(x)) {
            return Boolean.TRUE;
        }
        if ("false".equals(x)) {
            return Boolean.FALSE;
        }
        return Context.toString((Object)value);
    }

    public static final Object trim(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length < 1) {
            return "";
        }
        String str = RhinoScriptEngine._convertString(RhinoScriptEngine.nativeTo(args[0]));
        if (str != null) {
            return Context.toString((Object)RhinoScriptEngine.trimString(str));
        }
        return args[0];
    }

    public static final Object startsWith(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length < 2) {
            return Boolean.FALSE;
        }
        String str = RhinoScriptEngine._convertString(RhinoScriptEngine.nativeTo(args[0]));
        String chk = RhinoScriptEngine._convertString(RhinoScriptEngine.nativeTo(args[1]));
        if (str != null && str.length() > 0 && chk != null && chk.length() > 0) {
            return str.startsWith(chk) ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public static final Object endsWith(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length < 2) {
            return Boolean.FALSE;
        }
        String str = RhinoScriptEngine._convertString(RhinoScriptEngine.nativeTo(args[0]));
        String chk = RhinoScriptEngine._convertString(RhinoScriptEngine.nativeTo(args[1]));
        if (str != null && str.length() > 0 && chk != null && chk.length() > 0) {
            return str.endsWith(chk) ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public static final Object changeString(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length < 3) {
            return null;
        }
        String str = RhinoScriptEngine._convertString(RhinoScriptEngine.nativeTo(args[0]));
        String src = RhinoScriptEngine._convertString(RhinoScriptEngine.nativeTo(args[1]));
        String dest = RhinoScriptEngine._convertString(RhinoScriptEngine.nativeTo(args[2]));
        if (str != null && str.length() > 0 && src != null && src.length() > 0 && dest != null && dest.length() > 0) {
            return Context.toString((Object)RhinoScriptEngine._changeString(str, src, dest));
        }
        return args[0];
    }

    public static final Object currentTimeMillis(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        return new Long(System.currentTimeMillis());
    }

    private static final String className(Object o) {
        if (o == null) {
            return "Null";
        }
        String s = o.getClass().getName();
        int p = s.lastIndexOf(".");
        if (p != -1) {
            return s.substring(p + 1);
        }
        return s;
    }

    private static final boolean isNumber(int[] dot, Object o) {
        String s;
        if (dot != null && dot.length > 0) {
            dot[0] = 0;
        }
        if ("Double".equals(s = RhinoScriptEngine.className(o)) || "Float".equals(s) || "Integer".equals(s) || "Long".equals(s) || "Short".equals(s)) {
            if (dot != null && dot.length > 0) {
                if ("Double".equals(s)) {
                    dot[0] = 1;
                } else if ("Float".equals(s)) {
                    dot[0] = 2;
                }
            }
            return true;
        }
        if (dot != null && dot.length > 0) {
            dot[0] = 3;
        }
        return RhinoScriptEngine.isNumberByString(dot, o, s);
    }

    private static final boolean isNumberByString(int[] dot, Object o, String s) {
        if (s == null) {
            s = RhinoScriptEngine.className(o);
        }
        String num = null;
        if ("String".equals(s)) {
            num = RhinoScriptEngine.trimString((String)o);
        } else if ("NativeString".equals(s) || "NativeNumber".equals(s)) {
            num = RhinoScriptEngine.trimString(o.toString());
        } else {
            return false;
        }
        if (num == null || (num = RhinoScriptEngine.trimString(num)).length() <= 0) {
            return false;
        }
        s = null;
        int start = 0;
        if (num.startsWith("-")) {
            start = 1;
        }
        boolean dt = false;
        int len = num.length();
        if (start < len) {
            int i = start;
            while (i < len) {
                char c = num.charAt(i);
                if (c == '.') {
                    if (dt) {
                        return false;
                    }
                    if (dot != null && dot.length > 0) {
                        dot[0] = 4;
                    }
                    dt = true;
                } else if (c < '0' || c > '9') {
                    return false;
                }
                ++i;
            }
        } else {
            return false;
        }
        return true;
    }

    private static final String objectType(Object o, Scriptable thisObj) {
        if (o == null) {
            return "null";
        }
        if (o == Undefined.instance) {
            return "undefined";
        }
        if (o instanceof byte[]) {
            return "binary";
        }
        String s = RhinoScriptEngine.className(o);
        if ("String".equals(s) || "NativeString".equals(s)) {
            return "string";
        }
        if ("Boolean".equals(s) || "NativeBoolean".equals(s)) {
            return "boolean";
        }
        if ("Double".equals(s) || "Float".equals(s) || "Integer".equals(s) || "Long".equals(s) || "Short".equals(s) || "NativeNumber".equals(s)) {
            return "number";
        }
        if ("NativeArray".equals(s)) {
            return "array";
        }
        if ("NativeDate".equals(s)) {
            return "date";
        }
        if ("JSAdapter".equals(s)) {
            JSAdapter js = (JSAdapter)o;
            String type = (String)js.get("__getJSAdapterType", thisObj);
            if (type != null) {
                return type;
            }
            return "JSAdapter";
        }
        if (o instanceof Function || "FunctionObject".equals(s)) {
            return "function";
        }
        if ("NativeObject".equals(s)) {
            Object[] lst = ((Scriptable)o).getIds();
            int len = lst != null ? lst.length : 0;
            lst = null;
            if (len > 0) {
                return "map";
            }
        }
        return "object";
    }

    public static final String _convertString(Object o) {
        String s;
        if (o == null || o == Undefined.instance) {
            return "";
        }
        if (o instanceof String && (".".equals(s = (String)o) || s.endsWith("."))) {
            return s;
        }
        String clz = RhinoScriptEngine.className(o);
        if ("NativeDate".equals(clz)) {
            return Context.toString((Object)o);
        }
        if ("Double".equals(clz)) {
            Double d = (Double)o;
            long i = d.longValue();
            if (d == (double)i) {
                return String.valueOf(i);
            }
            return o.toString();
        }
        if ("Float".equals(clz)) {
            Float d = (Float)o;
            long i = d.longValue();
            if (d.floatValue() == (float)i) {
                return String.valueOf(i);
            }
            return o.toString();
        }
        if (RhinoScriptEngine.isNumberByString(null, o, clz)) {
            String s2 = RhinoScriptEngine._toString(o);
            int p = s2.indexOf(".");
            if (p != -1) {
                int len = s2.length();
                int i = p + 1;
                while (i < len) {
                    char c = s2.charAt(i);
                    if (c != '0') {
                        return s2;
                    }
                    ++i;
                }
                return s2.substring(0, p);
            }
            return s2;
        }
        return o.toString();
    }

    private static final Object _convertInt(Object o) {
        String s;
        if (o == null) {
            return "";
        }
        if (o == Undefined.instance) {
            return "undefined";
        }
        if (o instanceof String && (".".equals(s = (String)o) || s.endsWith("."))) {
            return s;
        }
        String clz = RhinoScriptEngine.className(o);
        if ("Long".equals(clz)) {
            return o;
        }
        if ("Short".equals(clz) || "Integer".equals(clz)) {
            return new Long(o.toString());
        }
        if ("Double".equals(clz)) {
            return new Long(((Double)o).longValue());
        }
        if ("Float".equals(clz)) {
            return new Long(((Float)o).longValue());
        }
        if (RhinoScriptEngine.isNumberByString(null, o, clz)) {
            String s2 = RhinoScriptEngine._toString(o);
            int p = s2.indexOf(".");
            if (p != -1) {
                s2 = s2.substring(0, p);
            }
            return new Long(s2);
        }
        return "NaN";
    }

    private static final Object _convertNumber(Object o) {
        String s;
        if (o == null) {
            return "";
        }
        if (o == Undefined.instance) {
            return "undefined";
        }
        if (o instanceof String && (".".equals(s = (String)o) || s.endsWith("."))) {
            return s;
        }
        String clz = RhinoScriptEngine.className(o);
        if ("Double".equals(clz)) {
            Double d = (Double)o;
            long i = d.longValue();
            if (d == (double)i) {
                return new Long(i);
            }
        } else if ("Float".equals(clz)) {
            Float d = (Float)o;
            long i = d.longValue();
            if (d.floatValue() == (float)i) {
                return new Long(i);
            }
            o = new Double(d.doubleValue());
        } else if (RhinoScriptEngine.isNumberByString(null, o, clz)) {
            String s2 = RhinoScriptEngine._toString(o);
            int p = s2.indexOf(".");
            if (p != -1) {
                int len = s2.length();
                int i = p + 1;
                while (i < len) {
                    char c = s2.charAt(i);
                    if (c != '0') {
                        return new Double(s2);
                    }
                    ++i;
                }
                s2 = s2.substring(0, p);
            }
            return new Long(s2);
        }
        return o;
    }

    private static final boolean isUseString(String str) {
        if (str == null || str.length() <= 0) {
            return false;
        }
        int len = str.length();
        int i = 0;
        while (i < len) {
            char c = str.charAt(i);
            if (c != ' ' && c != '\t' && c != '\u3000') {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static final String trimString(String string) {
        int s = -1;
        int e = -1;
        int len = string.length();
        s = 0;
        boolean sFlg = false;
        int i = 0;
        while (i < len) {
            char c = string.charAt(i);
            if (c != ' ' && c != '\u3000' && c != '\t') {
                s = i;
                break;
            }
            sFlg = true;
            ++i;
        }
        e = len - 1;
        boolean eFlg = false;
        int i2 = len - 1;
        while (i2 >= 0) {
            char c = string.charAt(i2);
            if (c != ' ' && c != '\u3000' && c != '\t') {
                e = i2;
                break;
            }
            eFlg = true;
            --i2;
        }
        if (sFlg && eFlg) {
            return string.substring(s, e + 1);
        }
        if (sFlg) {
            return string.substring(s);
        }
        if (eFlg) {
            return string.substring(0, e + 1);
        }
        return string;
    }

    private static final String _changeString(String str, String src, String dest) throws IllegalArgumentException {
        int end;
        int srcLen;
        StringBuilder buf = null;
        if (str == null || str.length() <= 0 || src == null || (srcLen = src.length()) <= 0) {
            if (str == null) {
                return "";
            }
            return str;
        }
        if (dest == null || dest.length() <= 0) {
            dest = "";
        }
        buf = new StringBuilder();
        int pnt = str.indexOf(src);
        if (pnt == -1) {
            return str;
        }
        if (pnt == 0) {
            buf.append(dest);
            end = srcLen;
        } else {
            buf.append(str.substring(0, pnt));
            buf.append(dest);
            end = pnt + srcLen;
        }
        pnt += srcLen;
        while (true) {
            if ((pnt = str.indexOf(src, pnt)) == -1) break;
            if (pnt == end) {
                buf.append(dest);
            } else {
                buf.append(str.substring(end, pnt));
                buf.append(dest);
            }
            end = pnt + srcLen;
            pnt += srcLen;
        }
        buf.append(str.substring(end));
        return buf.toString();
    }

    private static final String _toString(Object o) {
        if (o == null || o == Undefined.instance) {
            return "";
        }
        if (o instanceof String) {
            return RhinoScriptEngine.trimString((String)o);
        }
        return RhinoScriptEngine.trimString(o.toString());
    }
}

